/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.SlotGeneticFilter;
import forestry.sorting.gui.widgets.RuleWidget;
import forestry.sorting.gui.widgets.SelectionWidget;
import forestry.sorting.gui.widgets.SpeciesWidget;
import forestry.sorting.tiles.IFilterContainer;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class GuiGeneticFilter
extends GuiForestryTitled<ContainerGeneticFilter> {
    private final IFilterContainer tile;
    private final WidgetScrollBar scrollBar;
    public final SelectionWidget selection;
    @Nullable
    private EditBox searchField;

    public GuiGeneticFilter(ContainerGeneticFilter container, Inventory inventory, Component title) {
        super("textures/gui/filter.png", container, inventory, title);
        int i;
        this.f_97727_ = 222;
        this.f_97726_ = 212;
        this.tile = (IFilterContainer)container.getTile();
        for (i = 0; i < 6; ++i) {
            Direction facing = Direction.m_122376_((int)i);
            this.widgetManager.add(new RuleWidget(this.widgetManager, 44, 18 + i * 18, facing, this));
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.widgetManager.add(new SpeciesWidget(this.widgetManager, 80 + j * 45 + k * 18, 18 + i * 18, Direction.m_122376_((int)i), j, k == 0, this));
                }
            }
        }
        this.scrollBar = new WidgetScrollBar(this.widgetManager, 193, 150, 12, 64, new Drawable(new ResourceLocation("textures/gui/container/creative_inventory/tabs.png"), 232, 0, 12, 15));
        this.selection = new SelectionWidget(this.widgetManager, 0, 134, this.scrollBar, this);
        this.widgetManager.add(this.selection);
        this.widgetManager.add(this.scrollBar);
        this.scrollBar.setVisible(false);
    }

    public <S> void onModuleClick(ISelectableProvider<S> provider) {
        if (this.selection.isSame(provider)) {
            this.deselectFilter();
        } else {
            this.selectFilter(provider);
        }
    }

    private <S> void selectFilter(ISelectableProvider<S> provider) {
        this.selection.setProvider(provider);
        if (this.searchField != null) {
            this.searchField.m_94186_(true);
            this.searchField.m_94194_(true);
        }
        this.selection.filterEntries(this.searchField != null ? this.searchField.m_94155_() : "");
        for (Slot slot : ((ContainerGeneticFilter)this.f_97732_).f_38839_) {
            if (!(slot instanceof SlotGeneticFilter)) continue;
            SlotGeneticFilter filter = (SlotGeneticFilter)slot;
            filter.setEnabled(false);
        }
    }

    private void deselectFilter() {
        this.selection.setProvider(null);
        if (this.searchField != null) {
            this.searchField.m_94186_(false);
            this.searchField.m_94194_(false);
        }
        this.scrollBar.setVisible(false);
        for (Slot slot : ((ContainerGeneticFilter)this.f_97732_).f_38839_) {
            if (!(slot instanceof SlotGeneticFilter)) continue;
            SlotGeneticFilter filter = (SlotGeneticFilter)slot;
            filter.setEnabled(true);
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        String oldString = this.searchField != null ? this.searchField.m_94155_() : "";
        Font font = this.f_96541_.f_91062_;
        int n = this.f_97735_ + this.selection.getX() + 89 + 36;
        int n2 = this.selection.getY() + this.f_97736_ + 4;
        Objects.requireNonNull(this.f_96541_.f_91062_);
        this.searchField = new EditBox(font, n, n2, 80, 9, null);
        this.searchField.m_94199_(50);
        this.searchField.m_94182_(false);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94144_(oldString);
    }

    @Override
    protected void m_7286_(PoseStack transform, float partialTicks, int mouseY, int mouseX) {
        super.m_7286_(transform, partialTicks, mouseY, mouseX);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.searchField != null) {
            this.searchField.m_6305_(transform, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.m_7933_(key, scanCode, modifiers)) {
            this.scrollBar.setValue(0);
            this.selection.filterEntries(this.searchField.m_94155_());
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    @Override
    @Nullable
    protected Slot getSlotAtPosition(double mouseX, double mouseY) {
        Slot slot = super.getSlotAtPosition(mouseX, mouseY);
        if (slot instanceof SlotGeneticFilter && this.selection.getLogic() != null) {
            return null;
        }
        return slot;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        Widget widget;
        if (super.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.searchField != null) {
            this.searchField.m_6375_(mouseX, mouseY, mouseButton);
        }
        if ((widget = this.widgetManager.getAtPosition(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_)) == null) {
            this.deselectFilter();
        }
        return true;
    }

    @Override
    protected void addLedgers() {
        this.addHintLedger("filter");
    }

    public IFilterLogic getLogic() {
        return this.tile.getLogic();
    }
}

