/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.IForestryApi;
import forestry.api.client.ForestrySprites;
import forestry.api.client.IForestryClientApi;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.SoundUtil;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import java.util.Collection;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RuleWidget
extends Widget
implements ISelectableProvider<IFilterRuleType> {
    private static final ImmutableSet<IFilterRuleType> ENTRIES = RuleWidget.createEntries();
    private final Direction facing;
    private final GuiGeneticFilter gui;

    public RuleWidget(WidgetManager manager, int xPos, int yPos, Direction facing, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.facing = facing;
        this.gui = gui;
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        int x = this.xPos + startX;
        int y = this.yPos + startY;
        IFilterLogic logic = this.gui.getLogic();
        IFilterRuleType rule = logic.getRule(this.facing);
        this.draw(this.manager.gui, rule, transform, y, x);
        if (this.gui.selection.isSame(this)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)SelectionWidget.TEXTURE);
            this.gui.m_93228_(transform, x - 1, y - 1, 212, 0, 18, 18);
        }
    }

    @Override
    public Collection<IFilterRuleType> getEntries() {
        return ENTRIES;
    }

    @Override
    public void draw(GuiForestry gui, IFilterRuleType selectable, PoseStack transform, int y, int x) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ForestrySprites.TEXTURE_ATLAS);
        TextureAtlasSprite sprite = IForestryClientApi.INSTANCE.getTextureManager().getSprite(selectable.getSprite());
        GuiComponent.m_93200_((PoseStack)transform, (int)x, (int)y, (int)gui.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)sprite);
    }

    @Override
    public Component getName(IFilterRuleType selectable) {
        return Component.m_237115_((String)("for.gui.filter." + selectable.getId()));
    }

    @Override
    public void onSelect(IFilterRuleType selectable) {
        IFilterLogic logic = this.gui.getLogic();
        if (logic.setRule(this.facing, selectable)) {
            logic.sendToServer(this.facing, selectable);
        }
        if (this.gui.selection.isSame(this)) {
            this.gui.onModuleClick(this);
        }
        SoundUtil.playButtonClick();
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.onSelect(IForestryApi.INSTANCE.getFilterManager().getDefaultRule());
        } else {
            SoundUtil.playButtonClick();
            this.gui.onModuleClick(this);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFilterLogic logic = this.gui.getLogic();
        IFilterRuleType rule = logic.getRule(this.facing);
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.getName(rule));
        return tooltip;
    }

    private static ImmutableSet<IFilterRuleType> createEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (IFilterRuleType rule : IForestryApi.INSTANCE.getFilterManager().getRules()) {
            entries.add((Object)rule);
        }
        return entries.build();
    }
}

