/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import forestry.api.ForestryConstants;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionLogic;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SelectionWidget
extends Widget {
    public static final ResourceLocation TEXTURE = ForestryConstants.forestry("textures/gui/filter_selection.png");
    final WidgetScrollBar scrollBar;
    @Nullable
    private SelectionLogic logic;
    final GuiGeneticFilter gui;

    public SelectionWidget(WidgetManager manager, int xPos, int yPos, WidgetScrollBar scrollBar, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.width = 212;
        this.height = 88;
        this.scrollBar = scrollBar;
        this.gui = gui;
    }

    public <S> void setProvider(@Nullable ISelectableProvider<S> provider) {
        this.logic = provider == null ? null : new SelectionLogic<S>(this, provider);
    }

    public boolean isSame(ISelectableProvider provider) {
        return this.logic != null && this.logic.isSame(provider);
    }

    @Nullable
    public SelectionLogic getLogic() {
        return this.logic;
    }

    @Override
    public void draw(PoseStack transform, int startX, int startY) {
        if (this.logic == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.manager.gui.m_93228_(transform, startX + this.xPos, startY + this.yPos, 0, 0, this.width, this.height);
        this.logic.draw(transform);
        this.manager.minecraft.f_91062_.m_92889_(transform, (Component)Component.m_237115_((String)"for.gui.filter.seletion"), (float)(startX + this.xPos + 12), (float)(startY + this.yPos + 4), this.manager.gui.getFontColor().get("gui.title"));
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.logic != null && super.isMouseOver(mouseX, mouseY);
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        if (this.logic == null) {
            return null;
        }
        return this.logic.getToolTip(mouseX, mouseY);
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        if (this.logic == null) {
            return;
        }
        this.logic.select(mouseX, mouseY);
    }

    public void filterEntries(String filter) {
        if (this.logic == null) {
            return;
        }
        this.logic.filterEntries(filter);
    }
}

