/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.tiles;

import forestry.api.ForestryCapabilities;
import forestry.api.genetics.filter.FilterData;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.sorting.FilterLogic;
import forestry.sorting.features.SortingTiles;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.inventory.InventoryFilter;
import forestry.sorting.inventory.ItemHandlerFilter;
import forestry.sorting.tiles.IFilterContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileGeneticFilter
extends TileForestry
implements IStreamableGui,
IFilterContainer {
    private static final int TRANSFER_DELAY = 5;
    private final FilterLogic logic;
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache());

    public TileGeneticFilter(BlockPos pos, BlockState state) {
        super(SortingTiles.GENETIC_FILTER.tileType(), pos, state);
        this.logic = new FilterLogic(this, (logic1, level, player) -> this.sendToPlayers(level, player));
        this.setInternalInventory(new InventoryFilter(this));
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128365_("Logic", (Tag)this.logic.write(new CompoundTag()));
    }

    @Override
    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.logic.read(data.m_128469_("Logic"));
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        this.logic.writeGuiData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(FriendlyByteBuf data) {
        this.logic.readGuiData(data);
    }

    private void sendToPlayers(ServerLevel server, Player filterChanger) {
        for (Player player : server.m_6907_()) {
            if (player == filterChanger || !(player.f_36096_ instanceof ContainerGeneticFilter) || !((ContainerGeneticFilter)filterChanger.f_36096_).hasSameTile((ContainerGeneticFilter)player.f_36096_)) continue;
            ((ContainerGeneticFilter)player.f_36096_).setGuiNeedsUpdate(true);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.updateOnInterval(5)) {
            for (Direction facing : Direction.f_122346_) {
                ItemStack stack = this.m_8020_(facing.m_122411_());
                if (stack.m_41619_()) continue;
                ItemStack transferredStack = this.transferItem(stack, facing);
                int remaining = stack.m_41613_() - transferredStack.m_41613_();
                if (remaining > 0) {
                    stack = stack.m_41777_();
                    stack.m_41764_(remaining);
                    ItemStackUtil.dropItemStackAsEntity(stack.m_41777_(), level, this.f_58858_.m_123341_(), (float)this.f_58858_.m_123342_() + 0.5f, this.f_58858_.m_123343_());
                }
                this.m_6836_(facing.m_122411_(), ItemStack.f_41583_);
            }
        }
    }

    public boolean isConnected(Direction facing) {
        if (this.inventoryCache.getAdjacentInventory(facing) != null) {
            return true;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        return TileUtil.getInventoryFromTile(tileEntity, facing.m_122424_()) != null;
    }

    private ItemStack transferItem(ItemStack itemStack, Direction facing) {
        IItemHandler itemHandler = this.inventoryCache.getAdjacentInventory(facing);
        if (itemHandler == null) {
            return ItemStack.f_41583_;
        }
        ItemStack transferredStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack.m_41777_(), (boolean)true);
        if (transferredStack.m_41613_() == itemStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        transferredStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack.m_41777_(), (boolean)false);
        if (transferredStack.m_41619_()) {
            return itemStack;
        }
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(itemStack.m_41613_() - transferredStack.m_41613_());
        return copy;
    }

    public List<Direction> getValidDirections(ItemStack stack, Direction from) {
        return stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM).map(individual -> {
            FilterData filterData = new FilterData(individual.getIndividual(), individual.getStage());
            ArrayList<Direction> validFacings = new ArrayList<Direction>();
            for (Direction facing : Direction.f_122346_) {
                if (facing == from || !this.isValidFacing(facing, stack, filterData)) continue;
                validFacings.add(facing);
            }
            return validFacings;
        }).orElse(List.of());
    }

    private boolean isValidFacing(Direction facing, ItemStack itemStack, FilterData filterData) {
        return this.inventoryCache.getAdjacentInventory(facing) != null && this.logic.isValid(facing, itemStack, filterData);
    }

    @Override
    public FilterLogic getLogic() {
        return this.logic;
    }

    @Override
    public Container getBuffer() {
        return this;
    }

    @Override
    public TileGeneticFilter getTileEntity() {
        return this;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerGeneticFilter(windowId, player.m_150109_(), this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null) {
            return LazyOptional.of(() -> new ItemHandlerFilter(this, facing)).cast();
        }
        if (capability == ForestryCapabilities.FILTER_LOGIC) {
            return LazyOptional.of(() -> this.logic).cast();
        }
        return super.getCapability(capability, facing);
    }
}

