/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.core.utils.TagUtil;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackFilter
implements Predicate<ItemStack> {
    private final TagKey<Item> acceptKey;
    private final TagKey<Item> rejectKey;
    @Nullable
    private HolderSet<Item> cachedAccept;
    @Nullable
    private HolderSet<Item> cachedReject;

    public BackpackFilter(TagKey<Item> acceptKey, TagKey<Item> rejectKey) {
        this.acceptKey = acceptKey;
        this.rejectKey = rejectKey;
    }

    private HolderSet<Item> getAccept() {
        if (this.cachedAccept == null) {
            this.cachedAccept = BackpackFilter.getHolderSet(this.acceptKey);
        }
        return this.cachedAccept;
    }

    private HolderSet<Item> getReject() {
        if (this.cachedReject == null) {
            this.cachedReject = BackpackFilter.getHolderSet(this.rejectKey);
        }
        return this.cachedReject;
    }

    private static HolderSet<Item> getHolderSet(TagKey<Item> tagKey) {
        return (HolderSet)Registry.f_122827_.m_203431_(tagKey).orElseThrow(() -> new IllegalArgumentException("No tag holder set found for tag key: " + tagKey));
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return TagUtil.getHolder(itemStack).map(itemHolder -> this.getAccept().m_203333_(itemHolder) && !this.getReject().m_203333_(itemHolder)).orElse(false);
    }
}

