/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.client;

import forestry.api.client.IClientModuleHandler;
import forestry.api.modules.ForestryModuleIds;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import forestry.storage.client.FilledCrateModel;
import forestry.storage.features.BackpackMenuTypes;
import forestry.storage.gui.GuiBackpack;
import forestry.storage.items.ItemBackpack;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public class StorageClientHandler
implements IClientModuleHandler {
    public static final ModelResourceLocation FILLED_CRATE_MODEL = new ModelResourceLocation("forestry", "filled_crate", "inventory");

    @Override
    public void registerEvents(IEventBus modBus) {
        modBus.addListener(StorageClientHandler::registerAdditionalModels);
        modBus.addListener(StorageClientHandler::registerModelLoaders);
        modBus.addListener(StorageClientHandler::onModelBake);
        modBus.addListener(StorageClientHandler::onClientSetup);
        IFeatureRegistry registry = ModFeatureRegistry.get(ForestryModuleIds.STORAGE);
        registry.addRegistryListener(Registry.f_122904_, event -> {
            ItemPropertyFunction itemPropertyFunction = (stack, clientLevel, holder, idk) -> ItemBackpack.getMode(stack).ordinal();
            for (RegistryObject entry : registry.getRegistry(Registry.f_122904_).getEntries()) {
                if (!(entry.get() instanceof ItemBackpack)) continue;
                ItemProperties.register((Item)((Item)entry.get()), (ResourceLocation)new ResourceLocation("mode"), (ItemPropertyFunction)itemPropertyFunction);
            }
        });
    }

    private static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)FILLED_CRATE_MODEL);
    }

    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("filled_crate", (IGeometryLoader)new FilledCrateModel.Loader());
    }

    private static void onModelBake(ModelEvent.BakingCompleted event) {
        FilledCrateModel.cachedBaseModel = null;
        FilledCrateModel.transforms = null;
        FilledCrateModel.particle = null;
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_(BackpackMenuTypes.BACKPACK.menuType(), GuiBackpack::new);
            MenuScreens.m_96206_(BackpackMenuTypes.NATURALIST_BACKPACK.menuType(), GuiNaturalistInventory::new);
        });
    }
}

