/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.compat;

import forestry.core.utils.JeiUtil;
import forestry.core.utils.RecipeUtils;
import forestry.worktable.features.WorktableMenus;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.screens.WorktableMenu;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;

class WorktableRecipeTransferHandler
implements IRecipeTransferHandler<WorktableMenu, CraftingRecipe> {
    WorktableRecipeTransferHandler() {
    }

    public Class<WorktableMenu> getContainerClass() {
        return WorktableMenu.class;
    }

    public Optional<MenuType<WorktableMenu>> getMenuType() {
        return Optional.of(WorktableMenus.WORKTABLE.menuType());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(WorktableMenu container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (doTransfer) {
            CraftingContainer inventory = new CraftingContainer((AbstractContainerMenu)container, 3, 3);
            NonNullList<ItemStack> firstItemStacks = JeiUtil.getFirstItemStacks(recipeSlots);
            for (int i = 0; i < firstItemStacks.size(); ++i) {
                ItemStack firstItemStack = (ItemStack)firstItemStacks.get(i);
                inventory.m_6836_(i, firstItemStack);
            }
            List<CraftingRecipe> matchingRecipes = RecipeUtils.findMatchingRecipes(inventory, player.f_19853_);
            if (!matchingRecipes.isEmpty()) {
                MemorizedRecipe memorizedRecipe = new MemorizedRecipe(inventory, matchingRecipes);
                container.sendWorktableRecipeRequest(memorizedRecipe);
            }
        }
        return null;
    }
}

