/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.network.packets;

import forestry.api.modules.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.worktable.network.packets.PacketWorktableRecipeUpdate;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.screens.WorktableMenu;
import forestry.worktable.tiles.WorktableTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelReader;

public record PacketWorktableRecipeRequest(BlockPos pos, MemorizedRecipe recipe) implements IForestryPacketServer
{
    @Override
    public ResourceLocation id() {
        return PacketIdServer.WORKTABLE_RECIPE_REQUEST;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.recipe.writeData(buffer);
    }

    public static PacketWorktableRecipeRequest decode(FriendlyByteBuf buffer) {
        return new PacketWorktableRecipeRequest(buffer.m_130135_(), new MemorizedRecipe(buffer));
    }

    public static void handle(PacketWorktableRecipeRequest msg, ServerPlayer player) {
        BlockPos pos = msg.pos();
        MemorizedRecipe recipe = msg.recipe();
        TileUtil.actOnTile((LevelReader)player.f_19853_, pos, WorktableTile.class, worktable -> {
            worktable.setCurrentRecipe(recipe);
            AbstractContainerMenu patt1349$temp = player.f_36096_;
            if (patt1349$temp instanceof WorktableMenu) {
                WorktableMenu containerWorktable = (WorktableMenu)patt1349$temp;
                containerWorktable.updateCraftMatrix();
            }
            NetworkUtil.sendNetworkPacket(new PacketWorktableRecipeUpdate((WorktableTile)worktable), pos, player.f_19853_);
        });
    }
}

