/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.network.packets;

import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.tiles.WorktableTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;

public record PacketWorktableRecipeUpdate(BlockPos pos, @Nullable MemorizedRecipe recipe) implements IForestryPacketClient
{
    public PacketWorktableRecipeUpdate(WorktableTile tile) {
        this(tile.m_58899_(), tile.getCurrentRecipe());
    }

    @Override
    public ResourceLocation id() {
        return PacketIdClient.WORKTABLE_CRAFTING_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        NetworkUtil.writeStreamable(buffer, this.recipe);
    }

    public static PacketWorktableRecipeUpdate decode(FriendlyByteBuf buffer) {
        return new PacketWorktableRecipeUpdate(buffer.m_130135_(), NetworkUtil.readStreamable(buffer, MemorizedRecipe::new));
    }

    public static void handle(PacketWorktableRecipeUpdate msg, Player player) {
        TileUtil.actOnTile((LevelReader)player.f_19853_, msg.pos, WorktableTile.class, tile -> tile.setCurrentRecipe(msg.recipe));
    }
}

