/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.screens;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.WorktableSlot;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.worktable.features.WorktableMenus;
import forestry.worktable.inventory.WorktableCraftingContainer;
import forestry.worktable.network.packets.PacketWorktableMemoryUpdate;
import forestry.worktable.network.packets.PacketWorktableRecipeRequest;
import forestry.worktable.network.packets.PacketWorktableRecipeUpdate;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.tiles.WorktableTile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;

public class WorktableMenu
extends ContainerTile<WorktableTile>
implements IContainerCrafting,
IGuiSelectable {
    private final WorktableCraftingContainer craftMatrix = new WorktableCraftingContainer(this);
    private long lastMemoryUpdate;
    private boolean craftMatrixChanged = false;

    public static WorktableMenu fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        WorktableTile worktable = TileUtil.getTile((BlockGetter)playerInv.f_35978_.f_19853_, extraData.m_130135_(), WorktableTile.class);
        return new WorktableMenu(windowId, playerInv, worktable);
    }

    public WorktableMenu(int windowId, Inventory inv, WorktableTile tile) {
        super(windowId, WorktableMenus.WORKTABLE.menuType(), inv, tile, 8, 136);
        int i;
        Container craftingDisplay = tile.getCraftingDisplay();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.m_38897_(new SlotCraftMatrix(this, craftingDisplay, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.m_38897_(new WorktableSlot(inv.f_35978_, this.craftMatrix, craftingDisplay, tile, 9, 77, 38));
        for (i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            this.onCraftMatrixChanged(tile.getCraftingDisplay(), i);
        }
    }

    @Override
    public void m_38946_() {
        if (this.craftMatrixChanged) {
            this.craftMatrixChanged = false;
            ((WorktableTile)this.tile).setCurrentRecipe(this.craftMatrix);
            this.sendPacketToListeners(new PacketWorktableRecipeUpdate((WorktableTile)this.tile));
        }
        super.m_38946_();
        if (this.lastMemoryUpdate != ((WorktableTile)this.tile).getMemory().getLastUpdate()) {
            this.lastMemoryUpdate = ((WorktableTile)this.tile).getMemory().getLastUpdate();
            this.sendPacketToListeners(new PacketWorktableMemoryUpdate((WorktableTile)this.tile));
        }
    }

    public void updateCraftMatrix() {
        Container crafting = ((WorktableTile)this.tile).getCraftingDisplay();
        for (int i = 0; i < crafting.m_6643_(); ++i) {
            this.onCraftMatrixChanged(crafting, i);
        }
    }

    @Override
    public void onCraftMatrixChanged(Container iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.m_6643_()) {
            return;
        }
        ItemStack stack = iinventory.m_8020_(slot);
        if (!ItemStackUtil.isIdenticalItem(stack, currentStack = this.craftMatrix.m_8020_(slot))) {
            this.craftMatrix.m_6836_(slot, stack.m_41777_());
        }
    }

    public void m_6199_(Container container) {
        this.craftMatrixChanged = true;
    }

    public static void clearRecipe() {
        WorktableMenu.sendRecipeClick(-1, 0);
    }

    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(mouseButton, recipeIndex));
    }

    @Override
    public void handleSelectionRequest(ServerPlayer player, int primary, int secondary) {
        switch (primary) {
            case -1: {
                ((WorktableTile)this.tile).clearCraftMatrix();
                this.updateCraftMatrix();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((WorktableTile)this.tile));
                break;
            }
            case 0: {
                ((WorktableTile)this.tile).chooseRecipeMemory(secondary);
                this.updateCraftMatrix();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((WorktableTile)this.tile));
                break;
            }
            case 1: {
                long time = player.f_19853_.m_46467_();
                RecipeMemory memory = ((WorktableTile)this.tile).getMemory();
                memory.toggleLock(time, secondary);
                break;
            }
            case 100: {
                ((WorktableTile)this.tile).choosePreviousConflictRecipe();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((WorktableTile)this.tile));
                break;
            }
            case 101: {
                ((WorktableTile)this.tile).chooseNextConflictRecipe();
                this.sendPacketToListeners(new PacketWorktableRecipeUpdate((WorktableTile)this.tile));
            }
        }
    }

    public void sendWorktableRecipeRequest(MemorizedRecipe recipe) {
        NetworkUtil.sendToServer(new PacketWorktableRecipeRequest(((WorktableTile)this.tile).m_58899_(), recipe));
    }
}

