/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.tiles;

import forestry.core.inventory.InventoryGhostCrafting;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.RecipeUtils;
import forestry.worktable.features.WorktableTiles;
import forestry.worktable.inventory.WorktableCraftingContainer;
import forestry.worktable.inventory.WorktableInventory;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.screens.WorktableMenu;
import forestry.worktable.tiles.ICrafterWorktable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;

public class WorktableTile
extends TileBase
implements ICrafterWorktable {
    private RecipeMemory memory;
    private final InventoryGhostCrafting<WorktableTile> craftingDisplay;
    @Nullable
    private MemorizedRecipe currentRecipe;

    public WorktableTile(BlockPos pos, BlockState state) {
        super(WorktableTiles.WORKTABLE.tileType(), pos, state);
        this.setInternalInventory(new WorktableInventory(this));
        this.craftingDisplay = new InventoryGhostCrafting<WorktableTile>(this, 10);
        this.memory = new RecipeMemory();
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.craftingDisplay.write(data);
        this.memory.write(data);
    }

    @Override
    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.craftingDisplay.read(data);
        this.memory = new RecipeMemory(data);
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        this.craftingDisplay.writeData(data);
        this.memory.writeData(data);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.craftingDisplay.readData(data);
        this.memory.readData(data);
    }

    public boolean hasRecipeConflict() {
        return this.currentRecipe != null && this.currentRecipe.hasRecipeConflict();
    }

    public void chooseNextConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.incrementRecipe();
        }
    }

    public void choosePreviousConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.decrementRecipe();
        }
    }

    @Override
    public ItemStack getResult(CraftingContainer inventory, Level level) {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getCraftingResult(inventory, level);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean mayPickup(int craftingSlotIndex) {
        return craftingSlotIndex != 9 || this.canCraftCurrentRecipe();
    }

    private boolean canCraftCurrentRecipe() {
        return this.craftRecipe(true);
    }

    @Override
    public boolean onCraftingStart(Player player) {
        return this.craftRecipe(false);
    }

    private boolean craftRecipe(boolean simulate) {
        WorktableTile inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        CraftingRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe(this.f_58857_);
        if (selectedRecipe == null) {
            return false;
        }
        NonNullList<ItemStack> inventoryStacks = InventoryUtil.getStacks((Container)this);
        WorktableCraftingContainer usedMatrix = RecipeUtils.getUsedMatrix(this.currentRecipe.getCraftMatrix(), inventoryStacks, this.f_58857_, selectedRecipe);
        if (usedMatrix == null) {
            return false;
        }
        NonNullList<ItemStack> recipeItems = InventoryUtil.getStacks((Container)usedMatrix);
        if (simulate) {
            inventory = new SimpleContainer(this.m_6643_());
            InventoryUtil.deepCopyInventoryContents((Container)this, (Container)inventory);
        } else {
            inventory = this;
        }
        if (!InventoryUtil.deleteExactSet((Container)inventory, recipeItems)) {
            return false;
        }
        if (!simulate) {
            this.currentRecipe.setCraftMatrix(usedMatrix);
            this.setCurrentRecipe(this.currentRecipe);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(Player player) {
        CraftingRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe(this.f_58857_);
        ForgeHooks.setCraftingPlayer((Player)player);
        WorktableCraftingContainer craftMatrix = this.currentRecipe.getCraftMatrix();
        NonNullList remainingItems = selectedRecipe.m_7457_((Container)craftMatrix.copy());
        ForgeHooks.setCraftingPlayer(null);
        for (ItemStack remainingItem : remainingItems) {
            if (remainingItem == null || remainingItem.m_41619_() || InventoryUtil.tryAddStack((Container)this, remainingItem, true)) continue;
            player.m_36176_(remainingItem, false);
        }
        if (!this.f_58857_.f_46443_) {
            this.memory.memorizeRecipe(this.f_58857_.m_46467_(), this.currentRecipe, this.f_58857_);
        }
    }

    public RecipeMemory getMemory() {
        return this.memory;
    }

    public void chooseRecipeMemory(int recipeIndex) {
        MemorizedRecipe recipe = this.memory.getRecipe(recipeIndex);
        this.setCurrentRecipe(recipe);
    }

    private void setCraftingDisplay(Container craftMatrix) {
        for (int slot = 0; slot < craftMatrix.m_6643_(); ++slot) {
            ItemStack stack = craftMatrix.m_8020_(slot);
            this.craftingDisplay.m_6836_(slot, stack.m_41777_());
        }
    }

    public Container getCraftingDisplay() {
        return new InventoryMapper((Container)this.craftingDisplay, 0, 9);
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.m_6643_(); ++slot) {
            this.craftingDisplay.m_6836_(slot, ItemStack.f_41583_);
        }
    }

    public void setCurrentRecipe(CraftingContainer crafting) {
        NonNullList<ItemStack> currentStacks;
        NonNullList<ItemStack> stacks;
        MemorizedRecipe recipe;
        List<CraftingRecipe> recipes = RecipeUtils.getRecipes(RecipeType.f_44107_, crafting, this.f_58857_);
        MemorizedRecipe memorizedRecipe = recipe = recipes.isEmpty() ? null : new MemorizedRecipe(crafting, recipes);
        if (this.currentRecipe != null && recipe != null && recipe.hasRecipe(this.currentRecipe.getSelectedRecipe(this.f_58857_), this.f_58857_) && ItemStackUtil.equalSets(stacks = InventoryUtil.getStacks((Container)crafting), currentStacks = InventoryUtil.getStacks((Container)this.currentRecipe.getCraftMatrix()))) {
            return;
        }
        this.setCurrentRecipe(recipe);
    }

    @Nullable
    public MemorizedRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(@Nullable MemorizedRecipe recipe) {
        this.currentRecipe = recipe;
        if (this.currentRecipe != null) {
            this.setCraftingDisplay((Container)this.currentRecipe.getCraftMatrix());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new WorktableMenu(windowId, inv, this);
    }
}

