/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.FallingTreeUtils;
import fr.raksrinana.fallingtree.tree.Tree;
import fr.raksrinana.fallingtree.tree.TreeHandler;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class BlockBreakHandler
implements PlayerBlockBreakEvents.Before {
    public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 blockEntity) {
        if (!world.method_8608() && FallingTreeUtils.isPlayerInRightState(player)) {
            return TreeHandler.getTree(world, blockPos).map(tree -> {
                switch (FallingTree.config.getTreesConfiguration().getBreakMode()) {
                    case INSTANTANEOUS: {
                        return BlockBreakHandler.breakInstant(player, tree);
                    }
                    case SHIFT_DOWN: {
                        return BlockBreakHandler.breakShiftDown(player, tree);
                    }
                }
                return true;
            }).orElse(true);
        }
        return true;
    }

    private static boolean breakInstant(class_1657 player, Tree tree) {
        if (FallingTree.config.getTreesConfiguration().getMaxSize() < tree.getLogCount()) {
            player.method_9203((class_2561)new class_2588("chat.falling_tree.tree_too_big", new Object[]{tree.getLogCount(), FallingTree.config.getTreesConfiguration().getMaxSize()}), class_156.field_25140);
            return true;
        }
        return TreeHandler.destroyInstant(tree, player, player.method_6047());
    }

    private static boolean breakShiftDown(class_1657 player, Tree tree) {
        return TreeHandler.destroyShift(tree, player, player.method_6047());
    }
}

