/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.config.ToolConfiguration;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3494;

public class FallingTreeUtils {
    public static Set<class_1792> getAsItems(Collection<? extends String> names) {
        return names.stream().map(FallingTreeUtils::getItem).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static class_1792 getItem(String name) {
        try {
            return (class_1792)class_2378.field_11142.method_10223(new class_2960(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Set<class_2248> getAsBlocks(Collection<? extends String> names) {
        return names.stream().map(FallingTreeUtils::getBlock).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static class_2248 getBlock(String name) {
        try {
            return (class_2248)class_2378.field_11146.method_10223(new class_2960(name));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isTreeBlock(class_2248 block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = block.method_9525((class_3494)class_3481.field_15475) || FallingTree.config.getTreesConfiguration().getWhitelistedLogs().stream().anyMatch(log -> log.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = FallingTree.config.getTreesConfiguration().getBlacklistedLogs().stream().anyMatch(log -> log.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean isLeafBlock(class_2248 block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = block.method_9525((class_3494)class_3481.field_15503) || FallingTree.config.getTreesConfiguration().getWhitelistedLeaves().stream().anyMatch(leaf -> leaf.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = FallingTree.config.getTreesConfiguration().getBlacklistedLeaves().stream().anyMatch(leaf -> leaf.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean isPlayerInRightState(class_1657 player) {
        if (player.field_7503.field_7477 && !FallingTree.config.isBreakInCreative()) {
            return false;
        }
        if (FallingTree.config.isReverseSneaking() != player.method_5715()) {
            return false;
        }
        return FallingTreeUtils.canPlayerBreakTree(player);
    }

    public static boolean canPlayerBreakTree(class_1657 player) {
        boolean isWhitelistedTool;
        ToolConfiguration toolConfiguration = FallingTree.config.getToolsConfiguration();
        class_1792 heldItem = player.method_6047().method_7909();
        boolean bl = isWhitelistedTool = toolConfiguration.isIgnoreTools() || heldItem.method_7855(FabricToolTags.AXES) || toolConfiguration.getWhitelisted().stream().anyMatch(tool -> tool.equals(heldItem));
        if (isWhitelistedTool) {
            boolean isBlacklistedTool = toolConfiguration.getBlacklisted().stream().anyMatch(tool -> tool.equals(heldItem));
            return !isBlacklistedTool;
        }
        return false;
    }
}

