/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import fr.raksrinana.fallingtree.FallingTreeUtils;
import fr.raksrinana.fallingtree.config.BreakMode;
import fr.raksrinana.fallingtree.config.validator.Max;
import fr.raksrinana.fallingtree.config.validator.Min;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_2248;

public class TreeConfiguration {
    @Comment(value="Additional list of blocks considered as logs and that will be destroyed by the mod. INFO: Blocks marked with the log tag will already be whitelisted.")
    public List<String> whitelistedLogs = new ArrayList<String>();
    @Comment(value="List of blocks that should not be considered as logs. INFO: This wins over the whitelist.")
    public List<String> blacklistedLogs = new ArrayList<String>();
    @Comment(value="Additional list of blocks considered as leaves. INFO: Blocks marked with the leaves tag will already be whitelisted.")
    public List<String> whitelistedLeaves = new ArrayList<String>();
    @Comment(value="List of blocks that should not be considered as leaves. INFO: This wins over the whitelist.")
    public List<String> blacklistedLeaves = new ArrayList<String>();
    @Comment(value="How to break the tree. Instantaneous will break it in one go. Shift down will make the tree fall down as you cut it, so you still have to break x blocks but don't have to climb the tree for them.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public BreakMode breakMode = BreakMode.INSTANTANEOUS;
    @Comment(value="The maximum size of a tree. If there's more logs than this value the tree won't be cut. INFO: Only in INSTANTANEOUS mode.")
    @Min(value=1)
    public int maxSize = 100;
    @Comment(value="The minimum amount of leaves that needs to be around the top most log in order for the mod to consider it a tree. INFO: Only in INSTANTANEOUS mode.")
    @Min(value=0)
    @Max(value=5)
    public int minimumLeavesAroundRequired = 3;
    @Comment(value="When set to true, leaves that should naturally break will be broken instantly.")
    public boolean leavesBreaking = true;
    @Comment(value="Radius to force break leaves. If another tree is still holding the leaves they'll still be broken. If the leaves are persistent (placed by player) they'll also be destroyed. The radius is applied from one of the top most log blocks. INFO: break_leaves must be activated for this to take effect. INFO: Only in INSTANTANEOUS mode.")
    @Min(value=0)
    @Max(value=10)
    public int leavesBreakingForceRadius = 0;

    public Collection<class_2248> getBlacklistedLeaves() {
        return FallingTreeUtils.getAsBlocks(this.blacklistedLeaves);
    }

    public Collection<class_2248> getBlacklistedLogs() {
        return FallingTreeUtils.getAsBlocks(this.blacklistedLogs);
    }

    public BreakMode getBreakMode() {
        return this.breakMode;
    }

    public int getLeavesBreakingForceRadius() {
        return this.leavesBreakingForceRadius;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinimumLeavesAroundRequired() {
        return this.minimumLeavesAroundRequired;
    }

    public Collection<class_2248> getWhitelistedLeaves() {
        return FallingTreeUtils.getAsBlocks(this.whitelistedLeaves);
    }

    public Collection<class_2248> getWhitelistedLogs() {
        return FallingTreeUtils.getAsBlocks(this.whitelistedLogs);
    }

    public boolean isLeavesBreaking() {
        return this.leavesBreaking;
    }
}

