/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class Tree {
    private final class_1937 world;
    private final Set<class_2338> logs;
    private final class_2338 hitPos;

    public Tree(class_1937 world, class_2338 blockPos) {
        this.world = world;
        this.hitPos = blockPos;
        this.logs = new LinkedHashSet<class_2338>();
    }

    public void addLog(class_2338 blockPos) {
        if (Objects.nonNull(blockPos)) {
            this.logs.add(blockPos);
        }
    }

    public Optional<class_2338> getTopMostFurthestLog() {
        return this.getTopMostLog().flatMap(topMost -> this.logs.stream().filter(log -> Objects.equals(log.method_10264(), topMost.method_10264())).max(Comparator.comparingInt(this::getDistanceFromHit)));
    }

    public Optional<class_2338> getTopMostLog() {
        return this.logs.stream().max(Comparator.comparingInt(class_2382::method_10264));
    }

    public int getDistanceFromHit(class_2338 pos) {
        return Math.abs(this.hitPos.method_10263() - pos.method_10263()) + Math.abs(this.hitPos.method_10264() - pos.method_10264()) + Math.abs(this.hitPos.method_10260() - pos.method_10260());
    }

    public int getLogCount() {
        return this.logs.size();
    }

    public class_2338 getHitPos() {
        return this.hitPos;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public Collection<class_2338> getLogs() {
        return this.logs;
    }
}

