/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.FallingTreeUtils;
import fr.raksrinana.fallingtree.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class TreeHandler {
    public static Optional<Tree> getTree(class_1937 world, class_2338 blockPos) {
        class_2248 logBlock = world.method_8320(blockPos).method_26204();
        if (!FallingTreeUtils.isTreeBlock(logBlock)) {
            return Optional.empty();
        }
        LinkedList<class_2338> toAnalyzePos = new LinkedList<class_2338>();
        HashSet<class_2338> analyzedPos = new HashSet<class_2338>();
        Tree tree = new Tree(world, blockPos);
        toAnalyzePos.add(blockPos);
        while (!toAnalyzePos.isEmpty()) {
            class_2338 analyzingPos = (class_2338)toAnalyzePos.remove();
            tree.addLog(analyzingPos);
            analyzedPos.add(analyzingPos);
            Collection<class_2338> nearbyPos = TreeHandler.neighborLogs(world, logBlock, analyzingPos, analyzedPos);
            nearbyPos.removeAll(analyzedPos);
            toAnalyzePos.addAll(nearbyPos.stream().filter(pos -> !toAnalyzePos.contains(pos)).collect(Collectors.toList()));
        }
        if (FallingTree.config.getTreesConfiguration().getBreakMode().shouldCheckLeavesAround()) {
            int aroundRequired = FallingTree.config.getTreesConfiguration().getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> TreeHandler.getLeavesAround(world, topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static Collection<class_2338> neighborLogs(class_1937 world, class_2248 logBlock, class_2338 blockPos, Collection<class_2338> analyzedPos) {
        LinkedList<class_2338> neighborLogs = new LinkedList<class_2338>();
        class_2338.class_2339 checkPos = new class_2338.class_2339();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    checkPos.method_10103(blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z);
                    if (analyzedPos.contains(checkPos) || !TreeHandler.isSameLog(world, (class_2338)checkPos, logBlock)) continue;
                    neighborLogs.add(checkPos.method_10062());
                }
            }
        }
        neighborLogs.addAll(analyzedPos);
        return neighborLogs;
    }

    private static long getLeavesAround(class_1937 world, class_2338 blockPos) {
        return Arrays.stream(class_2350.values()).map(arg_0 -> ((class_2338)blockPos).method_10093(arg_0)).filter(testPos -> FallingTreeUtils.isLeafBlock(world.method_8320(testPos).method_26204())).count();
    }

    private static boolean isSameLog(class_1937 world, class_2338 blockPos, class_2248 logBlock) {
        return world.method_8320(blockPos).method_26204().equals(logBlock);
    }

    public static boolean destroyInstant(Tree tree, class_1657 player, class_1799 tool) {
        int radius;
        double rawWeightedUsesLeft;
        class_1937 world = tree.getWorld();
        int damageMultiplicand = FallingTree.config.getToolsConfiguration().getDamageMultiplicand();
        int toolUsesLeft = tool.method_7963() ? tool.method_7936() - tool.method_7919() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (FallingTree.config.getToolsConfiguration().isPreserve()) {
            if (rawWeightedUsesLeft <= 1.0) {
                player.method_9203((class_2561)new class_2588("chat.falling_tree.prevented_break_tool"), class_156.field_25140);
                return false;
            }
            if ((double)tree.getLogCount() >= rawWeightedUsesLeft) {
                rawWeightedUsesLeft = Math.ceil(rawWeightedUsesLeft) - 1.0;
            }
        }
        boolean isTreeFullyBroken = damageMultiplicand == 0 || rawWeightedUsesLeft >= (double)tree.getLogCount();
        tree.getLogs().stream().limit((int)rawWeightedUsesLeft).forEachOrdered(logBlock -> {
            class_2680 logState = world.method_8320(logBlock);
            logState.method_26204().method_9556(world, player, logBlock, logState, world.method_8321(logBlock), tool);
            world.method_8650(logBlock, false);
        });
        int toolDamage = damageMultiplicand * (int)Math.min((double)tree.getLogCount(), rawWeightedUsesLeft) - 1;
        if (toolDamage > 0) {
            tool.method_7956(toolDamage, (class_1309)player, entity -> {});
        }
        if (isTreeFullyBroken && (radius = FallingTree.config.getTreesConfiguration().getLeavesBreakingForceRadius()) > 0) {
            tree.getLogs().stream().max(Comparator.comparingInt(class_2382::method_10264)).ifPresent(topLog -> {
                class_2338.class_2339 checkPos = new class_2338.class_2339();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.method_10103(topLog.method_10263() + dx, topLog.method_10264() + dy, topLog.method_10260() + dz);
                            class_2680 checkState = world.method_8320((class_2338)checkPos);
                            class_2248 checkBlock = checkState.method_26204();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            class_2248.method_9497((class_2680)checkState, (class_1937)world, (class_2338)checkPos);
                            world.method_8650((class_2338)checkPos, false);
                        }
                    }
                }
            });
        }
        return true;
    }

    public static boolean destroyShift(Tree tree, class_1657 player, class_1799 tool) {
        double rawWeightedUsesLeft;
        class_1937 world = tree.getWorld();
        int damageMultiplicand = FallingTree.config.getToolsConfiguration().getDamageMultiplicand();
        int toolUsesLeft = tool.method_7963() ? tool.method_7936() - tool.method_7919() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (FallingTree.config.getToolsConfiguration().isPreserve() && rawWeightedUsesLeft <= 1.0) {
            player.method_9203((class_2561)new class_2588("chat.falling_tree.prevented_break_tool"), class_156.field_25140);
            return false;
        }
        tree.getTopMostFurthestLog().ifPresent(logBlock -> {
            class_2680 logState = world.method_8320(logBlock);
            logState.method_26204().method_9556(world, player, tree.getHitPos(), logState, world.method_8321(logBlock), tool);
            world.method_8650(logBlock, false);
        });
        int toolDamage = damageMultiplicand;
        if (toolDamage > 0) {
            tool.method_7956(toolDamage, (class_1309)player, entity -> {});
        }
        return false;
    }
}

