/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.client.reloadlisteners;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import moriyashiine.enchancement.common.Enchancement;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public class FrozenReloadListener
implements IdentifiableResourceReloadListener,
SimpleSynchronousResourceReloadListener {
    public static final FrozenReloadListener INSTANCE = new FrozenReloadListener();
    private static final class_2960 ID = Enchancement.id("frozen");
    private static final class_2960 PACKED_ICE_TEXTURE = new class_2960("textures/block/packed_ice.png");
    private static final boolean DEBUG_TEXTURES = Boolean.getBoolean("enchancement.debug_frozen_textures");
    private final Map<class_2960, class_2960> TEXTURE_CACHE = new HashMap<class_2960, class_2960>();

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        this.TEXTURE_CACHE.clear();
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singleton(ResourceReloadListenerKeys.TEXTURES);
    }

    public class_2960 getTexture(class_2960 original) {
        return this.TEXTURE_CACHE.computeIfAbsent(original, id -> {
            class_2960 class_29602;
            block8: {
                class_3300 resourceManager = class_310.method_1551().method_1478();
                class_1011 tex = FrozenReloadListener.loadNative(resourceManager, id);
                try {
                    class_29602 = FrozenReloadListener.generateTexture(resourceManager, tex.method_4307(), tex.method_4323());
                    if (tex == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (tex != null) {
                            try {
                                tex.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Enchancement.LOGGER.warn("Unable to generate frozen texture for " + String.valueOf(original), (Throwable)e);
                        return original;
                    }
                }
                tex.close();
            }
            return class_29602;
        });
    }

    private static class_2960 generateTexture(class_3300 resourceManager, int texWidth, int texHeight) throws IOException {
        try (class_1011 srcTex = FrozenReloadListener.loadNative(resourceManager, PACKED_ICE_TEXTURE);){
            if (srcTex.method_4307() == 0 || srcTex.method_4323() == 0) {
                throw new IllegalStateException(String.format("bad resourcepack, texture for %s was %sx%s, this is not allowed!", PACKED_ICE_TEXTURE, srcTex.method_4307(), srcTex.method_4323()));
            }
            int width = texWidth;
            int height = texHeight;
            if (texWidth % 16 == 0 && texHeight % 16 == 0) {
                width = srcTex.method_4307() * (texWidth / 16);
                height = srcTex.method_4323() * (texHeight / 16);
            }
            class_1011 destTex = new class_1011(width, height, false);
            for (int dx = 0; dx < width; ++dx) {
                for (int dy = 0; dy < height; ++dy) {
                    destTex.method_4305(dx, dy, srcTex.method_4315(dx % srcTex.method_4307(), dy % srcTex.method_4323()));
                }
            }
            class_2960 textureID = Enchancement.id(String.format("textures/generated/frozen_%sx%s", width, height));
            if (DEBUG_TEXTURES) {
                try {
                    Path dir = FabricLoader.getInstance().getGameDir().resolve("enchancement_debug");
                    Files.createDirectories(dir, new FileAttribute[0]);
                    Path output = dir.resolve(String.format("frozen_%sx%s.png", width, height));
                    destTex.method_4314(output);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            class_310.method_1551().method_1531().method_4616(textureID, (class_1044)new class_1043(destTex));
            class_2960 class_29602 = textureID;
            return class_29602;
        }
    }

    private static class_1011 loadNative(class_3300 resourceManager, class_2960 identifier) throws IOException {
        return class_1049.class_4006.method_18156((class_3300)resourceManager, (class_2960)identifier).method_18157();
    }
}

