/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import java.util.UUID;
import moriyashiine.enchancement.common.event.StepHeightEvent;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class ExtendedWaterComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private static final class_1322 SAFE_FALL_DISTANCE_MODIFIER = new class_1322(UUID.fromString("5a6cc485-ad0c-47d0-941e-a6011801bc34"), "Enchantment modifier", 4.0, class_1322.class_1323.field_6328);
    private final class_1309 obj;
    private int ticksWet = 0;
    private boolean hasAmphibious = false;
    private boolean hasBuoy = false;

    public ExtendedWaterComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.ticksWet = tag.method_10550("TicksWet");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("TicksWet", this.ticksWet);
    }

    public void tick() {
        this.hasAmphibious = EnchancementUtil.hasEnchantment(ModEnchantments.AMPHIBIOUS, (class_1297)this.obj);
        this.hasBuoy = EnchancementUtil.hasEnchantment(ModEnchantments.BUOY, (class_1297)this.obj);
        if (this.shouldCount()) {
            if (this.obj.method_5637()) {
                this.markWet(200);
            }
        } else {
            this.ticksWet = 0;
        }
        if (this.ticksWet > 0) {
            --this.ticksWet;
            if (this.hasAmphibious && this.obj.method_5809()) {
                this.obj.method_46395();
            }
        }
    }

    public void serverTick() {
        this.tick();
        if (this.obj.field_6012 % 10 == 0) {
            boolean increase = false;
            if (this.ticksWet > 0) {
                if (this.hasBuoy) {
                    increase = true;
                }
                if (!this.obj.method_5637()) {
                    this.obj.method_37908().method_8396(null, this.obj.method_24515(), class_3417.field_28035, this.obj.method_5634(), 1.0f, 1.0f);
                }
            }
            class_1324 safeFallDistanceAttribute = this.obj.method_5996(class_5134.field_49079);
            if (increase) {
                StepHeightEvent.ENTITIES.put(this, this.obj);
                if (!safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER)) {
                    safeFallDistanceAttribute.method_26837(SAFE_FALL_DISTANCE_MODIFIER);
                }
            } else {
                StepHeightEvent.ENTITIES.remove(this);
                if (safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER)) {
                    safeFallDistanceAttribute.method_6202(SAFE_FALL_DISTANCE_MODIFIER);
                }
            }
        }
    }

    public void clientTick() {
        this.tick();
        if (!(this.ticksWet <= 0 || this.obj.method_5767() || this.obj.method_5637() || !class_310.method_1551().field_1773.method_19418().method_19333() && class_310.method_1551().field_1724 == this.obj)) {
            if (this.hasAmphibious) {
                this.obj.method_37908().method_8406((class_2394)class_2398.field_18306, this.obj.method_23322(1.0), this.obj.method_23318() + (double)this.obj.method_17682() * class_3532.method_15366((class_5819)this.obj.method_6051(), (double)0.4, (double)0.8), this.obj.method_23325(1.0), 0.0, 0.0, 0.0);
            }
            if (this.hasBuoy) {
                this.obj.method_37908().method_8406((class_2394)class_2398.field_18306, this.obj.method_23322(1.0), this.obj.method_23318() + (double)this.obj.method_17682() * 0.15, this.obj.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        }
    }

    public void sync() {
        ModEntityComponents.EXTENDED_WATER.sync((Object)this.obj);
    }

    public int getTicksWet() {
        return this.ticksWet;
    }

    public void markWet(int ticks) {
        if (this.ticksWet < ticks) {
            this.ticksWet = ticks;
        }
    }

    public boolean hasAmphibious() {
        return this.hasAmphibious;
    }

    public boolean shouldCount() {
        return this.hasAmphibious || this.hasBuoy;
    }
}

