/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.GalePayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.enchancement.mixin.util.accessor.LivingEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class GaleComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final int DEFAULT_GALE_COOLDOWN = 10;
    private final class_1657 obj;
    private boolean shouldRefreshGale = false;
    private int galeCooldown = 10;
    private int lastGaleCooldown = 10;
    private int jumpCooldown = 10;
    private int jumpsLeft = 0;
    private int ticksInAir = 0;
    private int galeLevel = 0;
    private boolean hasGale = false;

    public GaleComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.shouldRefreshGale = tag.method_10577("ShouldRefreshGale");
        this.galeCooldown = tag.method_10550("GaleCooldown");
        this.lastGaleCooldown = tag.method_10550("LastGaleCooldown");
        this.jumpCooldown = tag.method_10550("JumpCooldown");
        this.jumpsLeft = tag.method_10550("JumpsLeft");
        this.ticksInAir = tag.method_10550("TicksInAir");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("ShouldRefreshGale", this.shouldRefreshGale);
        tag.method_10569("GaleCooldown", this.galeCooldown);
        tag.method_10569("LastGaleCooldown", this.lastGaleCooldown);
        tag.method_10569("JumpCooldown", this.jumpCooldown);
        tag.method_10569("JumpsLeft", this.jumpsLeft);
        tag.method_10569("TicksInAir", this.ticksInAir);
    }

    public void tick() {
        this.galeLevel = class_1890.method_8203((class_1887)ModEnchantments.GALE, (class_1309)this.obj);
        boolean bl = this.hasGale = this.galeLevel > 0;
        if (this.hasGale) {
            if (!this.shouldRefreshGale) {
                if (this.obj.method_24828()) {
                    this.shouldRefreshGale = true;
                }
            } else if (this.galeCooldown > 0) {
                --this.galeCooldown;
                if (this.galeCooldown == 0 && this.jumpsLeft < this.galeLevel) {
                    ++this.jumpsLeft;
                    this.setGaleCooldown(10);
                }
            }
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            }
            this.ticksInAir = this.obj.method_24828() ? 0 : ++this.ticksInAir;
        } else {
            this.shouldRefreshGale = false;
            this.galeCooldown = 10;
            this.jumpCooldown = 0;
            this.jumpsLeft = 0;
            this.ticksInAir = 0;
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasGale && ((LivingEntityAccessor)this.obj).enchancement$jumping() && this.canUse()) {
            this.use();
            GaleComponent.addGaleParticles((class_1297)this.obj);
            GalePayload.send();
        }
    }

    public void sync() {
        ModEntityComponents.GALE.sync((Object)this.obj);
    }

    public void setGaleCooldown(int galeCooldown) {
        this.galeCooldown = galeCooldown;
        this.lastGaleCooldown = galeCooldown;
    }

    public int getGaleCooldown() {
        return this.galeCooldown;
    }

    public int getLastGaleCooldown() {
        return this.lastGaleCooldown;
    }

    public int getJumpsLeft() {
        return this.jumpsLeft;
    }

    public void setJumpsLeft(int jumpsLeft) {
        this.jumpsLeft = jumpsLeft;
    }

    public int getGaleLevel() {
        return this.galeLevel;
    }

    public boolean hasGale() {
        return this.hasGale;
    }

    public boolean canUse() {
        return this.jumpCooldown == 0 && this.jumpsLeft > 0 && this.ticksInAir >= (this.obj.method_37908().field_9236 ? 10 : 9) && !this.obj.method_24828() && EnchancementUtil.isGroundedOrAirborne((class_1309)this.obj);
    }

    public void use() {
        this.obj.method_6043();
        this.obj.method_18800(this.obj.method_18798().method_10216(), this.obj.method_18798().method_10214() * 1.5, this.obj.method_18798().method_10215());
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_AIR_JUMP, 1.0f, 1.0f);
        this.setGaleCooldown(10);
        this.shouldRefreshGale = false;
        this.jumpCooldown = 10;
        --this.jumpsLeft;
    }

    public static void addGaleParticles(class_1297 entity) {
        if (class_310.method_1551().field_1773.method_19418().method_19333() || entity != class_310.method_1551().field_1719) {
            for (int i = 0; i < 8; ++i) {
                entity.method_37908().method_8406((class_2394)class_2398.field_11204, entity.method_23322(1.0), entity.method_23318(), entity.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        }
    }
}

