/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.enchancement.mixin.util.accessor.PersistentProjectileEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class PhasingComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1665 obj;
    private int phasingLevel = 0;
    private int ticksInAir = 0;
    private double velocityLength = -1.0;
    private class_243 freezeVelocity = null;

    public PhasingComponent(class_1665 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.phasingLevel = tag.method_10550("PhasingLevel");
        this.ticksInAir = tag.method_10550("TicksInAir");
        this.velocityLength = tag.method_10574("VelocityLength");
    }

    public void writeToNbt(@NotNull class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("PhasingLevel", this.phasingLevel);
        tag.method_10569("TicksInAir", this.ticksInAir);
        tag.method_10549("VelocityLength", this.velocityLength);
    }

    public void tick() {
        if (this.freezeVelocity != null) {
            this.obj.method_18799(this.freezeVelocity);
            this.freezeVelocity = null;
        }
        if (this.shouldPhase()) {
            if (++this.ticksInAir >= 200 || ((PersistentProjectileEntityAccessor)this.obj).enchancement$inGround()) {
                this.disablePhasing();
                return;
            }
            class_1309 closest = null;
            for (class_1309 living : this.obj.method_37908().method_8390(class_1309.class, new class_238(this.obj.method_24515()).method_1014((double)this.phasingLevel * 0.5), foundEntity -> foundEntity.method_5805() && EnchancementUtil.shouldHurt(this.obj.method_24921(), (class_1297)foundEntity))) {
                if (closest != null && !(closest.method_5739((class_1297)this.obj) > living.method_5739((class_1297)this.obj))) continue;
                closest = living;
            }
            if (closest != null) {
                if (this.obj.method_37908().field_9236) {
                    for (int i = 0; i < 8; ++i) {
                        this.obj.method_37908().method_8406((class_2394)class_2398.field_11214, this.obj.method_23322(0.5), this.obj.method_23319(), this.obj.method_23325(0.5), 0.0, 0.0, 0.0);
                    }
                } else {
                    if (this.velocityLength == -1.0) {
                        this.velocityLength = this.obj.method_18798().method_1033();
                        this.obj.method_37908().method_8396(null, this.obj.method_24515(), ModSoundEvents.ENTITY_GENERIC_TELEPORT, this.obj.method_5634(), 0.75f, 1.0f);
                    }
                    this.obj.method_18800(closest.method_23317() - this.obj.method_23317(), closest.method_23320() - this.obj.method_23320(), closest.method_23321() - this.obj.method_23321());
                }
            }
        }
    }

    public void sync() {
        ModEntityComponents.PHASING.sync((Object)this.obj);
    }

    public int getPhasingLevel() {
        return this.phasingLevel;
    }

    public void setPhasingLevel(int phasingLevel) {
        this.phasingLevel = phasingLevel;
    }

    public boolean shouldPhase() {
        return this.phasingLevel > 0;
    }

    public double getVelocityLength() {
        return this.velocityLength;
    }

    public void disablePhasing() {
        this.setPhasingLevel(0);
        this.velocityLength = -1.0;
        this.freezeVelocity = this.obj.method_18798();
        this.obj.method_18799(class_243.field_1353);
        this.obj.method_5875(false);
    }
}

