/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import java.util.UUID;
import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.common.event.StepHeightEvent;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.SlideResetVelocityPayload;
import moriyashiine.enchancement.common.payload.SlideSetVelocityPayload;
import moriyashiine.enchancement.common.payload.SlideSlamPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.enchancement.mixin.util.accessor.EntityAccessor;
import moriyashiine.enchancement.mixin.util.accessor.LivingEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5691;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class SlideComponent
implements CommonTickingComponent {
    public static final int DEFAULT_JUMP_BOOST_RESET_TICKS = 5;
    public static final int DEFAULT_SLAM_COOLDOWN = 7;
    private static final class_1322 SAFE_FALL_DISTANCE_MODIFIER = new class_1322(UUID.fromString("72d836d9-33eb-4a26-a12c-3cba2346d296"), "Enchantment modifier", 6.0, class_1322.class_1323.field_6328);
    private final class_1657 obj;
    private SlideVelocity velocity = SlideVelocity.ZERO;
    private boolean isSlamming = false;
    private int jumpBoostResetTicks = 5;
    private int slamCooldown = 7;
    private int ticksLeftToJump = 0;
    private int ticksSliding = 0;
    private int slideLevel = 0;
    private boolean hasSlide = false;
    private boolean wasPressingSlamKey = false;

    public SlideComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.velocity = new SlideVelocity(tag.method_10583("VelocityX"), tag.method_10583("VelocityZ"));
        this.isSlamming = tag.method_10577("IsSlamming");
        this.jumpBoostResetTicks = tag.method_10550("JumpBoostResetTicks");
        this.slamCooldown = tag.method_10550("SlamCooldown");
        this.ticksLeftToJump = tag.method_10550("TicksLeftToJump");
        this.ticksSliding = tag.method_10550("TicksSliding");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10548("VelocityX", this.velocity.x());
        tag.method_10548("VelocityZ", this.velocity.z());
        tag.method_10556("IsSlamming", this.isSlamming);
        tag.method_10569("JumpBoostResetTicks", this.jumpBoostResetTicks);
        tag.method_10569("SlamCooldown", this.slamCooldown);
        tag.method_10569("TicksLeftToJump", this.ticksLeftToJump);
        tag.method_10569("TicksSliding", this.ticksSliding);
    }

    public void tick() {
        boolean hasBuoy = EnchancementUtil.hasEnchantment(ModEnchantments.BUOY, (class_1297)this.obj);
        this.slideLevel = class_1890.method_8203((class_1887)ModEnchantments.SLIDE, (class_1309)this.obj);
        boolean bl = this.hasSlide = this.slideLevel > 0;
        if (this.hasSlide) {
            if (this.obj.method_5715() || this.obj.method_5799() && !hasBuoy) {
                this.velocity = SlideVelocity.ZERO;
            }
            if (this.slamCooldown > 0) {
                --this.slamCooldown;
            }
            if (this.ticksLeftToJump > 0) {
                --this.ticksLeftToJump;
            }
            if (this.isSliding()) {
                ((EntityAccessor)this.obj).enchancement$spawnSprintingParticles();
                this.obj.method_37908().method_32888((class_6880)class_5712.field_28155, this.obj.method_19538(), class_5712.class_7397.method_43287((class_2680)this.obj.method_25936()));
                double dX = this.velocity.x();
                double dZ = this.velocity.z();
                if (!this.obj.method_24828()) {
                    dX *= 0.2;
                    dZ *= 0.2;
                }
                this.obj.method_5762(dX, 0.0, dZ);
                if (this.obj.method_5799() && hasBuoy) {
                    this.obj.method_18800(this.obj.method_18798().method_10216(), (double)this.slideLevel * 0.25, this.obj.method_18798().method_10215());
                }
                if (this.ticksSliding < 60) {
                    ++this.ticksSliding;
                }
            } else if (this.ticksSliding > 0) {
                this.ticksSliding = Math.max(0, this.ticksSliding - 4);
            }
        } else {
            this.velocity = SlideVelocity.ZERO;
            this.isSlamming = false;
            this.jumpBoostResetTicks = 5;
            this.slamCooldown = 7;
            this.ticksLeftToJump = 0;
            this.ticksSliding = 0;
        }
    }

    public void serverTick() {
        this.tick();
        if (this.hasSlide && this.isSlamming) {
            this.slamTick(() -> {
                this.obj.method_37908().method_8333((class_1297)this.obj, new class_238(this.obj.method_24515()).method_1009(5.0, 1.0, 5.0), foundEntity -> foundEntity.method_5805() && foundEntity.method_5739((class_1297)this.obj) < 5.0f).forEach(entity -> {
                    class_1309 living;
                    if (entity instanceof class_1309 && EnchancementUtil.shouldHurt((class_1297)this.obj, (class_1297)(living = (class_1309)entity))) {
                        living.method_6005(1.0, this.obj.method_23317() - living.method_23317(), this.obj.method_23321() - living.method_23321());
                    }
                });
                this.obj.method_37908().method_32888((class_6880)class_5712.field_28155, this.obj.method_19538(), class_5712.class_7397.method_43287((class_2680)this.obj.method_25936()));
                class_2680 state = this.obj.method_37908().method_8320(this.obj.method_43260());
                if (state.method_28498((class_2769)class_2741.field_28063) && state.method_28498((class_2769)class_2741.field_28062) && state.method_11654((class_2769)class_2741.field_28063) == class_5691.field_28065 && state.method_11654((class_2769)class_2741.field_28062) == class_2350.field_11036) {
                    this.obj.method_5643(this.obj.method_48923().method_48837(), 2.1474836E9f);
                }
            });
            EnchancementUtil.PACKET_IMMUNITIES.put((Object)this.obj, 20);
        }
        class_1324 safeFallDistanceAttribute = this.obj.method_5996(class_5134.field_49079);
        if (this.hasSlide && this.isSliding()) {
            StepHeightEvent.ENTITIES.put(this, (class_1309)this.obj);
            if (!safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER)) {
                safeFallDistanceAttribute.method_26837(SAFE_FALL_DISTANCE_MODIFIER);
            }
            EnchancementUtil.PACKET_IMMUNITIES.put((Object)this.obj, 20);
        } else {
            StepHeightEvent.ENTITIES.remove(this);
            if (safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER)) {
                safeFallDistanceAttribute.method_6202(SAFE_FALL_DISTANCE_MODIFIER);
            }
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasSlide && !this.obj.method_7325() && this.obj == class_310.method_1551().field_1724) {
            boolean pressingSlamKey;
            if (this.isSlamming) {
                this.slamTick(() -> {
                    class_2338.class_2339 mutable = new class_2338.class_2339();
                    for (int i = 0; i < 360; i += 15) {
                        for (int j = 1; j < 5; ++j) {
                            double x = this.obj.method_23317() + (double)(class_3532.method_15374((float)i) * (float)j / 2.0f);
                            double z = this.obj.method_23321() + (double)(class_3532.method_15362((float)i) * (float)j / 2.0f);
                            class_2680 state = this.obj.method_37908().method_8320((class_2338)mutable.method_10102(x, (double)Math.round(this.obj.method_23318() - 1.0), z));
                            if (state.method_45474() || !this.obj.method_37908().method_8320((class_2338)mutable.method_10098(class_2350.field_11036)).method_45474()) continue;
                            this.obj.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, state), x, (double)mutable.method_10264(), z, 0.0, 0.0, 0.0);
                        }
                    }
                });
            }
            class_315 options = class_310.method_1551().field_1690;
            if (EnchancementClient.SLIDE_KEYBINDING.method_1434() && !this.obj.method_5715() && !((LivingEntityAccessor)this.obj).enchancement$jumping()) {
                if (this.canSlide()) {
                    this.velocity = this.getVelocityFromInput(options).rotateY((float)Math.toRadians(-(this.obj.method_5791() + 90.0f)));
                    SlideSetVelocityPayload.send(this.velocity);
                }
            } else if (this.velocity != SlideVelocity.ZERO) {
                this.velocity = SlideVelocity.ZERO;
                SlideResetVelocityPayload.send();
            }
            if ((pressingSlamKey = EnchancementClient.SLAM_KEYBINDING.method_1434()) && !this.wasPressingSlamKey && this.canSlam()) {
                this.isSlamming = true;
                this.slamCooldown = 7;
                SlideSlamPayload.send();
            }
            this.wasPressingSlamKey = pressingSlamKey;
        } else {
            this.wasPressingSlamKey = false;
        }
    }

    public void setVelocity(SlideVelocity velocity) {
        this.velocity = velocity;
    }

    public void setSlamming(boolean slamming) {
        this.isSlamming = slamming;
    }

    public boolean isSlamming() {
        return this.isSlamming;
    }

    public void setSlamCooldown(int slamCooldown) {
        this.slamCooldown = slamCooldown;
    }

    public boolean isSliding() {
        return !this.velocity.equals(SlideVelocity.ZERO);
    }

    public boolean shouldBoostJump() {
        return this.ticksLeftToJump > 0;
    }

    public float getJumpBonus() {
        return class_3532.method_16439((float)((float)this.ticksSliding / 60.0f), (float)1.0f, (float)3.0f);
    }

    public int getSlideLevel() {
        return this.slideLevel;
    }

    public boolean hasSlide() {
        return this.hasSlide;
    }

    public boolean canSlide() {
        return !this.isSliding() && this.obj.method_24828() && EnchancementUtil.isGroundedOrAirborne((class_1309)this.obj);
    }

    public boolean canSlam() {
        return this.slamCooldown == 0 && !this.isSliding() && !this.obj.method_24828() && EnchancementUtil.isGroundedOrAirborne((class_1309)this.obj);
    }

    private void slamTick(Runnable onLand) {
        this.obj.method_18800(this.obj.method_18798().method_10216() * 0.98, -3.0, this.obj.method_18798().method_10215() * 0.98);
        this.obj.field_6017 = 0.0f;
        if (this.obj.method_24828()) {
            this.isSlamming = false;
            this.ticksLeftToJump = 5;
            this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_IMPACT, 1.0f, 1.0f);
            onLand.run();
        }
    }

    private SlideVelocity getVelocityFromInput(class_315 options) {
        boolean any = false;
        boolean forward = false;
        boolean sideways = false;
        int x = 0;
        int z = 0;
        if (options.field_1894.method_1434()) {
            any = true;
            forward = true;
            x = 1;
        }
        if (options.field_1881.method_1434()) {
            any = true;
            forward = true;
            x = -1;
        }
        if (options.field_1913.method_1434()) {
            any = true;
            sideways = true;
            z = -1;
        }
        if (options.field_1849.method_1434()) {
            any = true;
            sideways = true;
            z = 1;
        }
        return new SlideVelocity(any ? (float)x : 1.0f, z).multiply(forward && sideways ? 0.75f : 1.0f).multiply((float)this.slideLevel * 0.25f);
    }

    public record SlideVelocity(float x, float z) {
        public static final SlideVelocity ZERO = new SlideVelocity(0.0f, 0.0f);

        SlideVelocity multiply(float value) {
            return new SlideVelocity(this.x() * value, this.z() * value);
        }

        SlideVelocity rotateY(float angle) {
            float cos = class_3532.method_15362((float)angle);
            float sin = class_3532.method_15374((float)angle);
            float nX = this.x() * cos + this.z() * sin;
            float nZ = this.z() * cos - this.x() * sin;
            return new SlideVelocity(nX, nZ);
        }
    }
}

