/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.StrafePayload;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class StrafeComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final int DEFAULT_STRAFE_COOLDOWN = 40;
    private final class_1657 obj;
    private int strafeCooldown = 40;
    private int lastStrafeCooldown = 40;
    private int strafeLevel = 0;
    private boolean hasStrafe = false;
    private boolean wasPressingStrafeKey = false;
    private int ticksLeftToPressActivationKey = 0;

    public StrafeComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.strafeCooldown = tag.method_10550("StrafeCooldown");
        this.lastStrafeCooldown = tag.method_10550("LastStrafeCooldown");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("StrafeCooldown", this.strafeCooldown);
        tag.method_10569("LastStrafeCooldown", this.lastStrafeCooldown);
    }

    public void tick() {
        this.strafeLevel = class_1890.method_8203((class_1887)ModEnchantments.STRAFE, (class_1309)this.obj);
        boolean bl = this.hasStrafe = this.strafeLevel > 0;
        if (this.hasStrafe) {
            if (this.strafeCooldown > 0) {
                --this.strafeCooldown;
            }
        } else {
            this.setStrafeCooldown(40);
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasStrafe && this.canUse() && this.obj == class_310.method_1551().field_1724) {
            class_315 options = class_310.method_1551().field_1690;
            boolean pressingStrafeKey = EnchancementClient.STRAFE_KEYBINDING.method_1434();
            if (this.ticksLeftToPressActivationKey > 0) {
                --this.ticksLeftToPressActivationKey;
            }
            if (pressingStrafeKey && !this.wasPressingStrafeKey) {
                if (this.ticksLeftToPressActivationKey > 0 || ModConfig.singlePressStrafe) {
                    this.ticksLeftToPressActivationKey = 0;
                    class_243 inputVelocity = this.getVelocityFromInput(options);
                    if (inputVelocity != class_243.field_1353) {
                        class_243 velocity = inputVelocity.method_1024((float)Math.toRadians(-(this.obj.method_5791() + 90.0f)));
                        this.use(velocity.method_10216(), velocity.method_10215());
                        StrafeComponent.addStrafeParticles((class_1297)this.obj);
                        StrafePayload.send(velocity);
                    }
                } else {
                    this.ticksLeftToPressActivationKey = 7;
                }
            }
            this.wasPressingStrafeKey = pressingStrafeKey;
        }
    }

    public int getStrafeCooldown() {
        return this.strafeCooldown;
    }

    public void setStrafeCooldown(int strafeCooldown) {
        this.strafeCooldown = strafeCooldown;
        this.lastStrafeCooldown = strafeCooldown;
    }

    public int getLastStrafeCooldown() {
        return this.lastStrafeCooldown;
    }

    public boolean hasStrafe() {
        return this.hasStrafe;
    }

    public boolean canUse() {
        return this.strafeCooldown == 0 && !this.obj.method_7325();
    }

    public void use(double velocityX, double velocityZ) {
        this.obj.method_5762(velocityX, 0.0, velocityZ);
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_STRAFE, 1.0f, 1.0f);
        this.setStrafeCooldown(40 / this.strafeLevel);
    }

    private class_243 getVelocityFromInput(class_315 options) {
        if (options.field_1894.method_1434()) {
            return new class_243(1.0, 0.0, 0.0);
        }
        if (options.field_1881.method_1434()) {
            return new class_243(-1.0, 0.0, 0.0);
        }
        if (options.field_1913.method_1434()) {
            return new class_243(0.0, 0.0, -1.0);
        }
        if (options.field_1849.method_1434()) {
            return new class_243(0.0, 0.0, 1.0);
        }
        return class_243.field_1353;
    }

    public static void addStrafeParticles(class_1297 entity) {
        if (class_310.method_1551().field_1773.method_19418().method_19333() || entity != class_310.method_1551().field_1719) {
            for (int i = 0; i < 8; ++i) {
                entity.method_37908().method_8406((class_2394)class_2398.field_11204, entity.method_23322(1.0), entity.method_23319(), entity.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        }
    }
}

