/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class LumberjackComponent
implements ServerTickingComponent {
    private final class_1937 obj;
    private final List<Tree> treesToCut = new ArrayList<Tree>();

    public LumberjackComponent(class_1937 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 treesToCut = tag.method_10554("TreesToCut", 10);
        for (int i = 0; i < treesToCut.size(); ++i) {
            this.treesToCut.add(Tree.deserialize(registryLookup, treesToCut.method_10602(i)));
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 treesToCut = new class_2499();
        treesToCut.addAll(this.treesToCut.stream().map(tree -> tree.serialize(registryLookup)).toList());
        tag.method_10566("TreesToCut", (class_2520)treesToCut);
    }

    public void serverTick() {
        for (int i = this.treesToCut.size() - 1; i >= 0; --i) {
            Tree tree = this.treesToCut.get(i);
            class_2338 pos = tree.logs.removeLast();
            tree.drops.addAll(class_2248.method_9562((class_2680)this.obj.method_8320(pos), (class_3218)((class_3218)this.obj), (class_2338)pos, (class_2586)this.obj.method_8321(pos)));
            this.obj.method_22352(pos, false);
            if (!tree.logs.isEmpty()) continue;
            EnchancementUtil.mergeItemEntities(tree.drops.stream().map(drop -> new class_1542(this.obj, (double)tree.originalPos.method_10263() + 0.5, (double)tree.originalPos.method_10264() + 0.5, (double)tree.originalPos.method_10260() + 0.5, drop)).collect(Collectors.toList())).forEach(arg_0 -> ((class_1937)this.obj).method_8649(arg_0));
            this.treesToCut.remove(i);
        }
    }

    public void addTree(Tree tree) {
        this.treesToCut.add(tree);
    }

    public static class Tree {
        public final List<class_2338> logs;
        public final List<class_1799> drops;
        public final class_2338 originalPos;

        public Tree(List<class_2338> logs, class_2338 originalPos) {
            this.logs = logs;
            this.drops = new ArrayList<class_1799>();
            this.originalPos = originalPos;
        }

        public class_2487 serialize(class_7225.class_7874 registryLookup) {
            class_2487 compound = new class_2487();
            compound.method_10538("Logs", this.logs.stream().map(class_2338::method_10063).toList());
            class_2499 drops = new class_2499();
            this.drops.forEach(stack -> {
                if (!stack.method_7960()) {
                    drops.add((Object)stack.method_57358(registryLookup));
                }
            });
            compound.method_10566("Drops", (class_2520)drops);
            compound.method_10544("OriginalPos", this.originalPos.method_10063());
            return compound;
        }

        public static Tree deserialize(class_7225.class_7874 registryLookup, class_2487 compound) {
            Tree tree = new Tree(Arrays.stream(compound.method_10565("Logs")).mapToObj(class_2338::method_10092).collect(Collectors.toList()), class_2338.method_10092((long)compound.method_10537("OriginalPos")));
            class_2499 drops = compound.method_10554("Drops", 10);
            for (int i = 0; i < drops.size(); ++i) {
                class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)drops.method_10602(i)).ifPresent(tree.drops::add);
            }
            return tree;
        }
    }
}

