/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.entity.projectile;

import java.util.HashSet;
import java.util.Set;
import moriyashiine.enchancement.common.init.ModDamageTypes;
import moriyashiine.enchancement.common.init.ModDataComponentTypes;
import moriyashiine.enchancement.common.init.ModEntityTypes;
import moriyashiine.enchancement.common.tag.ModEntityTypeTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public class BrimstoneEntity
extends class_1665 {
    public static final class_1799 BRIMSTONE_STACK = new class_1799((class_1935)class_1802.field_8187);
    public static final class_2940<Float> DAMAGE;
    public static final class_2940<Float> FORCED_PITCH;
    public static final class_2940<Float> FORCED_YAW;
    private static final class_2390 PARTICLE;
    public float maxY = 0.0f;
    public int ticksExisted = 0;
    private final Set<class_1297> hitEntities = new HashSet<class_1297>();
    private final Set<class_1297> killedEntities = new HashSet<class_1297>();

    public BrimstoneEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5985 = true;
    }

    public BrimstoneEntity(class_1937 world, class_1309 owner) {
        super(ModEntityTypes.BRIMSTONE, owner, world, class_1799.field_8037);
        this.method_5814(owner.method_23317(), owner.method_23320() - 0.3, owner.method_23321());
        this.field_5985 = true;
    }

    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    public void method_5773() {
        if (this.method_7443()) {
            this.method_7439(false);
        }
        this.method_18799(class_243.field_1353);
        ++this.ticksExisted;
        this.maxY = 0.0f;
        class_243 start = this.method_19538();
        class_243 end = start.method_1019(this.method_5720());
        while (this.maxY < 256.0f) {
            this.maxY += 1.0f;
            class_3965 hitResult = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                if (!this.method_37908().field_9236) break;
                this.addParticles(hitResult.method_17784().method_10216(), hitResult.method_17784().method_10214(), hitResult.method_17784().method_10215());
                break;
            }
            if (this.ticksExisted == 3) {
                class_1297 owner = this.method_24921();
                this.method_37908().method_8333(owner, class_238.method_29968((class_243)hitResult.method_17784()).method_1014(0.5), class_1301.field_6155.and(entity -> this.canEntityBeHit(owner, (class_1297)entity))).forEach(entity -> {
                    if (this.method_37908().field_9236) {
                        this.addParticles(entity.method_23317(), entity.method_23319(), entity.method_23321());
                    } else {
                        class_1309 living;
                        double damage = this.method_7448();
                        if (entity instanceof class_1309) {
                            living = (class_1309)entity;
                            damage *= (double)(living.method_6063() / 20.0f);
                        }
                        damage = this.maxY < 16.0f ? (damage *= (double)class_3532.method_16439((float)(this.maxY / 16.0f), (float)0.25f, (float)1.0f)) : (damage *= (double)Math.min(2.0f, class_3532.method_16439((float)((this.maxY - 16.0f) / 200.0f), (float)1.0f, (float)2.0f)));
                        damage = Math.min(50.0, damage);
                        entity.method_5643(ModDamageTypes.create(this.method_37908(), ModDamageTypes.BRIMSTONE, (class_1297)this, owner), (float)damage);
                        this.hitEntities.add((class_1297)entity);
                        if (entity instanceof class_1309 && (living = (class_1309)entity).method_29504()) {
                            this.killedEntities.add((class_1297)living);
                        }
                    }
                });
            }
            start = end;
            end = start.method_1019(this.method_5720());
        }
        if (!this.method_37908().field_9236) {
            if (this.ticksExisted == 3) {
                this.method_37908().method_32888((class_6880)class_5712.field_28162, end, class_5712.class_7397.method_43285((class_1297)this));
            }
            if (this.ticksExisted > 10) {
                class_1297 class_12972 = this.method_24921();
                if (class_12972 instanceof class_3222) {
                    class_3222 player = (class_3222)class_12972;
                    class_174.field_1197.method_8980(player, this.killedEntities);
                }
                this.method_31472();
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
    }

    protected void method_24920(class_3965 blockHitResult) {
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_7438(nbt.method_10583("Damage"));
        this.field_6011.method_12778(FORCED_PITCH, (Object)Float.valueOf(nbt.method_10583("ForcedPitch")));
        this.field_6011.method_12778(FORCED_YAW, (Object)Float.valueOf(nbt.method_10583("ForcedYaw")));
        this.ticksExisted = nbt.method_10550("TicksExisted");
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("Damage", (float)this.method_7448());
        nbt.method_10548("ForcedPitch", this.method_36455());
        nbt.method_10548("ForcedYaw", this.method_36454());
        nbt.method_10569("TicksExisted", this.ticksExisted);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORCED_PITCH, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public float method_36455() {
        return ((Float)this.field_6011.method_12789(FORCED_PITCH)).floatValue();
    }

    public float method_36454() {
        return ((Float)this.field_6011.method_12789(FORCED_YAW)).floatValue();
    }

    public void method_7438(double damage) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf((float)damage));
    }

    public double method_7448() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    private void addParticles(double x, double y, double z) {
        float range = (float)class_3532.method_16436((double)(this.method_7448() / 12.0), (double)0.0, (double)0.3f);
        for (int i = 0; i < 8; ++i) {
            this.method_37908().method_8406((class_2394)PARTICLE, x + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), y + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), z + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f));
        }
    }

    private boolean canEntityBeHit(class_1297 owner, class_1297 entity) {
        if (entity instanceof class_1309 || entity.method_5864().method_20210(ModEntityTypeTags.BRIMSTONE_HITTABLE)) {
            return !this.hitEntities.contains(entity) && entity.method_5805() && EnchancementUtil.shouldHurt(owner, entity);
        }
        return false;
    }

    static {
        BRIMSTONE_STACK.method_57379(ModDataComponentTypes.BRIMSTONE_DAMAGE, (Object)Integer.MAX_VALUE);
        DAMAGE = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        FORCED_PITCH = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        FORCED_YAW = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        PARTICLE = new class_2390(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
    }
}

