/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.event;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.component.world.LumberjackComponent;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModWorldComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import org.jetbrains.annotations.Nullable;

public class LumberjackEvent
implements PlayerBlockBreakEvents.Before {
    public static final List<Entry> ENTRIES = new ArrayList<Entry>();

    public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        Entry entry;
        class_1799 stack = player.method_6047();
        if (LumberjackEvent.canActivate(player, stack, state) && (entry = Entry.get(player)) != null && LumberjackEvent.isValid(entry.tree())) {
            boolean[] broken = new boolean[]{false};
            stack.method_7972().method_7956(entry.tree().size(), world.method_8409(), null, () -> {
                broken[0] = true;
            });
            if (!broken[0]) {
                entry.tree().sort(Comparator.comparingInt(class_2382::method_10264).reversed());
                ((LumberjackComponent)ModWorldComponents.LUMBERJACK.get((Object)world)).addTree(new LumberjackComponent.Tree(entry.tree(), pos));
                ENTRIES.remove(entry);
                return false;
            }
        }
        return true;
    }

    public static List<class_2338> gatherTree(List<class_2338> tree, class_1922 world, class_2338.class_2339 pos, class_2248 original) {
        if (tree.size() < ModConfig.maxLumberjackBlocks) {
            int originalX = pos.method_10263();
            int originalY = pos.method_10264();
            int originalZ = pos.method_10260();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2680 state = world.method_8320((class_2338)pos.method_10103(originalX + x, originalY + y, originalZ + z));
                        if (!state.method_26164(class_3481.field_15475) || tree.contains(pos) || state.method_26204() != original) continue;
                        tree.add(pos.method_10062());
                        LumberjackEvent.gatherTree(tree, world, pos, original);
                    }
                }
            }
        }
        return tree;
    }

    public static boolean isWithinHorizontalBounds(List<class_2338> tree) {
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        for (class_2338 pos : tree) {
            if (minX == null || pos.method_10263() < minX) {
                minX = pos.method_10263();
            }
            if (maxX == null || pos.method_10263() > maxX) {
                maxX = pos.method_10263();
            }
            if (minZ == null || pos.method_10260() < minZ) {
                minZ = pos.method_10260();
            }
            if (maxZ != null && pos.method_10260() <= maxZ) continue;
            maxZ = pos.method_10260();
        }
        if (minX == null) {
            return false;
        }
        return Math.abs(maxX - minX) < ModConfig.maxLumberjackHorizontalLength && Math.abs(maxZ - minZ) < ModConfig.maxLumberjackHorizontalLength;
    }

    public static boolean canActivate(class_1657 player, class_1799 stack, class_2680 state) {
        return !player.method_5715() && EnchancementUtil.hasEnchantment(ModEnchantments.LUMBERJACK, stack) && state.method_26164(class_3481.field_15475) && player.method_7305(state);
    }

    public static boolean isValid(List<class_2338> tree) {
        return tree.size() > 1 && tree.size() <= ModConfig.maxLumberjackBlocks && LumberjackEvent.isWithinHorizontalBounds(tree);
    }

    public record Entry(class_1657 player, List<class_2338> tree) {
        @Nullable
        public static Entry get(class_1657 player) {
            for (Entry entry : ENTRIES) {
                if (entry.player != player) continue;
                return entry;
            }
            return null;
        }
    }
}

