/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.screenhandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moriyashiine.enchancement.client.payload.SyncEnchantingTableBookshelfCountPayload;
import moriyashiine.enchancement.client.payload.SyncEnchantingTableCostPayload;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.init.ModScreenHandlerTypes;
import moriyashiine.enchancement.common.tag.ModEnchantmentTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_174;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_6880;
import net.minecraft.class_7716;
import net.minecraft.class_7923;

public class EnchantingTableScreenHandler
extends class_1703 {
    public static final Map<class_6880<class_1792>, class_1856> ENCHANTING_MATERIAL_MAP = new HashMap<class_6880<class_1792>, class_1856>();
    public static final int PAGE_SIZE = 4;
    public final List<class_1887> validEnchantments = new ArrayList<class_1887>();
    public final List<class_1887> selectedEnchantments = new ArrayList<class_1887>();
    public int viewIndex = 0;
    private class_1799 enchantingStack = class_1799.field_8037;
    private class_1856 repairIngredient = class_1856.field_9017;
    private int bookshelfCount = 0;
    private int cost = 0;
    private final class_1263 inventory = new class_1277(3){

        public void method_5431() {
            super.method_5431();
            EnchantingTableScreenHandler.this.method_7609((class_1263)this);
        }
    };
    private final class_3914 context;

    public EnchantingTableScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public EnchantingTableScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(ModScreenHandlerTypes.ENCHANTING_TABLE, syncId);
        int index;
        this.context = context;
        this.bookshelfCount = this.calculateBookshelfCount();
        class_1657 class_16572 = playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            SyncEnchantingTableBookshelfCountPayload.send(player, this.bookshelfCount);
        }
        this.method_7621(new class_1735(this.inventory, 0, 15, 31){

            public boolean method_7680(class_1799 stack) {
                if (stack.method_7923()) {
                    for (class_1887 enchantment : class_7923.field_41176) {
                        if (!EnchantingTableScreenHandler.isEnchantmentAllowed(enchantment, stack)) continue;
                        return true;
                    }
                }
                return false;
            }

            public int method_7675() {
                return 1;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                EnchantingTableScreenHandler.this.validEnchantments.clear();
                EnchantingTableScreenHandler.this.selectedEnchantments.clear();
                EnchantingTableScreenHandler.this.viewIndex = 0;
                EnchantingTableScreenHandler.this.enchantingStack = class_1799.field_8037;
                EnchantingTableScreenHandler.this.repairIngredient = class_1856.field_9017;
                EnchantingTableScreenHandler.this.cost = 0;
                player.method_31548().method_7398(((class_1735)EnchantingTableScreenHandler.this.field_7761.get(2)).method_7677());
                super.method_7667(player, stack);
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 1, 35, 31){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(class_1802.field_8759);
            }
        });
        this.method_7621(new class_1735(this.inventory, 2, 25, 51){

            public boolean method_7680(class_1799 stack) {
                return EnchantingTableScreenHandler.this.getRepairIngredient(((class_1735)EnchantingTableScreenHandler.this.field_7761.getFirst()).method_7677()).method_8093(stack);
            }
        });
        for (index = 0; index < 3; ++index) {
            for (int i = 0; i < 9; ++i) {
                this.method_7621(new class_1735((class_1263)playerInventory, i + index * 9 + 9, 8 + i * 18, 84 + index * 18));
            }
        }
        for (index = 0; index < 9; ++index) {
            this.method_7621(new class_1735((class_1263)playerInventory, index, 8 + index * 18, 142));
        }
    }

    public boolean method_7597(class_1657 player) {
        return EnchantingTableScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)class_2246.field_10485);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            stack = stackInSlot.method_7972();
            if (index == 0 || index == 1 || index == 2) {
                if (!this.method_7616(stackInSlot, 3, 38, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.repairIngredient.method_8093(stackInSlot)) {
                if (!this.method_7616(stackInSlot, 2, 3, false)) {
                    return class_1799.field_8037;
                }
            } else if (stackInSlot.method_31574(class_1802.field_8759)) {
                if (!this.method_7616(stackInSlot, 1, 2, false)) {
                    return class_1799.field_8037;
                }
            } else if (!((class_1735)this.field_7761.getFirst()).method_7681() && ((class_1735)this.field_7761.getFirst()).method_7680(stackInSlot)) {
                ((class_1735)this.field_7761.getFirst()).method_53512(stackInSlot.method_7971(1));
            } else {
                return class_1799.field_8037;
            }
            if (stackInSlot.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return stack;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            if (this.canEnchant(player, player.method_7337())) {
                this.context.method_17393((world, pos) -> {
                    class_1799 stack = ((class_1735)this.field_7761.getFirst()).method_7677();
                    for (class_1887 enchantment : this.selectedEnchantments) {
                        stack.method_7978(enchantment, EnchancementUtil.alterLevel(stack, enchantment));
                    }
                    if (!player.method_7337() && this.cost > 0) {
                        player.method_7286(stack, this.cost);
                    }
                    player.method_7281(class_3468.field_15420);
                    class_174.field_1181.method_8870((class_3222)player, stack, this.cost);
                    world.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                    if (!player.method_7337() && this.cost > 0) {
                        ((class_1735)this.field_7761.get(1)).method_7677().method_7934(this.cost);
                        if (!this.getRepairIngredient(((class_1735)this.field_7761.get(0)).method_7677()).method_8103()) {
                            ((class_1735)this.field_7761.get(2)).method_7677().method_7934(this.cost);
                        }
                    }
                    this.inventory.method_5431();
                });
                return true;
            }
        } else {
            if (id == 1) {
                this.updateViewIndex(true);
                return true;
            }
            if (id == 2) {
                this.updateViewIndex(false);
                return true;
            }
            if (id > 2 && id < 8) {
                class_1887 enchantment = this.getEnchantmentFromViewIndex(id - 4);
                if (this.selectedEnchantments.contains(enchantment)) {
                    this.selectedEnchantments.remove(enchantment);
                } else {
                    this.selectedEnchantments.add(enchantment);
                }
                this.cost = this.getCost(((class_1735)this.field_7761.getFirst()).method_7677());
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    SyncEnchantingTableCostPayload.send(serverPlayer, this.cost);
                }
                return true;
            }
        }
        return false;
    }

    public void method_7609(class_1263 inventory) {
        class_1799 stack;
        if (inventory == this.inventory && this.enchantingStack != (stack = ((class_1735)this.field_7761.getFirst()).method_7677())) {
            this.validEnchantments.clear();
            this.selectedEnchantments.clear();
            this.viewIndex = 0;
            this.enchantingStack = stack;
            this.repairIngredient = this.getRepairIngredient(stack);
            this.cost = 0;
            for (class_1887 enchantment : class_7923.field_41176) {
                if (!EnchantingTableScreenHandler.isEnchantmentAllowed(enchantment, stack) || EnchancementUtil.isDefaultEnchantment(stack, enchantment)) continue;
                this.validEnchantments.add(enchantment);
            }
            super.method_7609(inventory);
        }
    }

    public class_1887 getEnchantmentFromViewIndex(int index) {
        if (this.validEnchantments.size() <= 4) {
            return this.validEnchantments.get(index);
        }
        return this.validEnchantments.get((index + this.viewIndex) % this.validEnchantments.size());
    }

    public boolean canEnchant(class_1657 player, boolean simulate) {
        if (((class_1735)this.field_7761.get(0)).method_7681()) {
            if (!((class_1735)this.field_7761.get(0)).method_7677().method_7923()) {
                return false;
            }
            if (simulate) {
                return true;
            }
            if (player.field_7520 >= this.cost && ((class_1735)this.field_7761.get(1)).method_7677().method_7947() >= this.cost) {
                if (!this.getRepairIngredient(((class_1735)this.field_7761.get(0)).method_7677()).method_8103()) {
                    return ((class_1735)this.field_7761.get(2)).method_7677().method_7947() >= this.cost;
                }
                return true;
            }
        }
        return false;
    }

    public class_1856 getRepairIngredient() {
        return this.repairIngredient;
    }

    private class_1856 getRepairIngredient(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_1856 ingredient = ENCHANTING_MATERIAL_MAP.getOrDefault(class_7923.field_41178.method_47983((Object)item), class_1856.field_9017);
        if (ingredient.method_8103()) {
            class_1831 toolItem;
            class_1856 repairIngredient;
            if (item instanceof class_1738) {
                class_1738 armorItem = (class_1738)item;
                class_1856 repairIngredient2 = (class_1856)((class_1741)armorItem.method_7686().comp_349()).comp_2301().get();
                if (!repairIngredient2.method_8103()) {
                    ingredient = repairIngredient2;
                }
            } else if (item instanceof class_1831 && !(repairIngredient = (toolItem = (class_1831)item).method_8022().method_8023()).method_8103()) {
                ingredient = repairIngredient;
            }
        }
        return ingredient;
    }

    private int calculateBookshelfCount() {
        float[] bookshelfCountArray = new float[]{0.0f};
        this.context.method_17393((world, pos) -> {
            for (class_2338 offset : class_2331.field_36535) {
                if (EnchantingTableScreenHandler.canAccessPowerProvider(world, pos, offset)) {
                    bookshelfCountArray[0] = bookshelfCountArray[0] + 1.0f;
                    continue;
                }
                class_2586 patt0$temp = world.method_8321(pos.method_10081((class_2382)offset));
                if (!(patt0$temp instanceof class_7716)) continue;
                class_7716 chiseledBookshelfBlockEntity = (class_7716)patt0$temp;
                if (!world.method_8320(pos.method_10069(offset.method_10263() / 2, offset.method_10264(), offset.method_10260() / 2)).method_26164(class_3481.field_44473)) continue;
                bookshelfCountArray[0] = bookshelfCountArray[0] + (float)chiseledBookshelfBlockEntity.method_47587() / 3.0f;
            }
        });
        return Math.min(15, (int)bookshelfCountArray[0]);
    }

    public int getCost() {
        return this.cost;
    }

    private int getCost(class_1799 stack) {
        int enchantability = 13;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            enchantability = armorItem.method_7837();
        } else {
            class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1831) {
                class_1831 toolItem = (class_1831)class_17922;
                enchantability = toolItem.method_7837();
            }
        }
        double cost = 60.0f / (float)Math.max(1, enchantability + this.bookshelfCount);
        cost = this.bookshelfCount == 15 ? (double)class_3532.method_15357((double)cost) : (double)class_3532.method_15384((double)cost);
        return (int)(cost * (double)this.selectedEnchantments.size());
    }

    public void updateViewIndex(boolean up) {
        this.viewIndex = (this.viewIndex + (up ? -1 : 1)) % this.validEnchantments.size();
        if (this.viewIndex < 0) {
            this.viewIndex += this.validEnchantments.size();
        }
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    private static boolean canAccessPowerProvider(class_1937 world, class_2338 tablePos, class_2338 providerOffset) {
        return world.method_8320(tablePos.method_10081((class_2382)providerOffset)).method_26164(class_3481.field_44472) && world.method_8320(tablePos.method_10069(providerOffset.method_10263() / 2, providerOffset.method_10264(), providerOffset.method_10260() / 2)).method_26164(class_3481.field_44473);
    }

    private static boolean isEnchantmentAllowed(class_1887 enchantment, class_1799 stack) {
        class_6880 entry = class_7923.field_41176.method_47983((Object)enchantment);
        if (entry.method_40220(ModEnchantmentTags.NEVER_SELECTABLE)) {
            return false;
        }
        if (stack.canBeEnchantedWith(enchantment, EnchantingContext.RANDOM_ENCHANTMENT)) {
            if (entry.method_40220(ModEnchantmentTags.ALWAYS_SELECTABLE)) {
                return true;
            }
            if (enchantment.method_25950()) {
                return ModConfig.allowTreasureEnchantmentsInEnchantingTable || !enchantment.method_8193();
            }
        }
        return false;
    }
}

