/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.event.InitializeDefaultEnchantmentsEvent;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.tag.ModEntityTypeTags;
import moriyashiine.enchancement.common.tag.ModItemTags;
import moriyashiine.enchancement.common.util.SubmersionGate;
import moriyashiine.enchancement.mixin.util.accessor.ItemEntityAccessor;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalFluidTags;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8046;
import net.minecraft.class_8786;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class EnchancementUtil {
    public static final Object2IntMap<class_1887> ORIGINAL_MAX_LEVELS = new Object2IntOpenHashMap();
    public static final Object2IntMap<class_1657> PACKET_IMMUNITIES = new Object2IntOpenHashMap();
    public static final int MAXIMUM_MOVEMENT_MULTIPLIER = 4;
    public static boolean hasScatterShot = false;
    public static boolean shouldCancelTargetDamagedEnchantments = false;

    public static List<class_1542> mergeItemEntities(List<class_1542> drops) {
        for (int i = drops.size() - 1; i >= 0; --i) {
            if (i >= drops.size() - 1) continue;
            class_1542 itemEntity = drops.get(i);
            class_1542 other = drops.get(i + 1);
            ((ItemEntityAccessor)itemEntity).enchancement$tryMerge(other);
            if (itemEntity.method_6983().method_7960()) {
                drops.remove(i);
            }
            if (!other.method_6983().method_7960()) continue;
            drops.remove(i + 1);
        }
        return drops;
    }

    @Nullable
    public static class_1887 getRandomEnchantment(class_1799 stack, class_5819 random) {
        ArrayList<class_1887> enchantments = new ArrayList<class_1887>();
        for (class_1887 enchantment : class_7923.field_41176) {
            if (!stack.canBeEnchantedWith(enchantment, EnchantingContext.RANDOM_ENCHANTMENT)) continue;
            enchantments.add(enchantment);
        }
        if (!enchantments.isEmpty()) {
            return (class_1887)enchantments.get(random.method_43048(enchantments.size()));
        }
        return null;
    }

    @Nullable
    public static class_1887 getReplacement(class_1887 enchantment, class_1799 stack) {
        ArrayList<class_1887> enchantments = new ArrayList<class_1887>();
        for (class_1887 entry : class_7923.field_41176) {
            if (!entry.method_45382(entry.method_45322()) || !stack.method_31574(class_1802.field_8598) && !stack.canBeEnchantedWith(entry, EnchantingContext.RANDOM_ENCHANTMENT)) continue;
            enchantments.add(entry);
        }
        if (enchantments.isEmpty()) {
            return null;
        }
        int index = (enchantment.method_8184().hashCode() + stack.method_7922().hashCode()) % enchantments.size();
        if (index < 0) {
            index += enchantments.size();
        }
        return (class_1887)enchantments.get(index);
    }

    public static boolean hasEnchantment(class_1887 enchantment, class_1799 stack) {
        return class_1890.method_8225((class_1887)enchantment, (class_1799)stack) > 0;
    }

    public static boolean hasEnchantment(class_1887 enchantment, class_1297 entity) {
        class_1309 living;
        return entity instanceof class_1309 && class_1890.method_8203((class_1887)enchantment, (class_1309)(living = (class_1309)entity)) > 0;
    }

    public static boolean hasWeakEnchantments(class_1799 stack) {
        class_1792 material;
        if (stack.method_31573(ModItemTags.STRONGLY_ENCHANTED)) {
            return false;
        }
        if (stack.method_31573(ModItemTags.WEAKLY_ENCHANTED)) {
            return true;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            material = (class_1741)armorItem.method_7686().comp_349();
            for (class_1741 mat : class_7923.field_48976) {
                if (material != mat) continue;
                return mat == class_1740.field_7897.comp_349() || mat == class_1740.field_7892.comp_349();
            }
            return material.comp_2299() <= ((class_1741)class_1740.field_7892.comp_349()).comp_2299();
        }
        material = stack.method_7909();
        if (material instanceof class_1831) {
            class_1831 toolItem = (class_1831)material;
            material = toolItem.method_8022();
            for (class_1834 mat : class_1834.values()) {
                if (material != mat) continue;
                return mat == class_1834.field_8922 || mat == class_1834.field_8927 || mat == class_1834.field_8923;
            }
            return material.method_8026() <= class_1834.field_8923.method_8026();
        }
        return false;
    }

    public static boolean isEnchantmentAllowed(class_2960 identifier) {
        if (identifier == null) {
            return true;
        }
        if (ModConfig.invertedList) {
            return ModConfig.disallowedEnchantments.contains(identifier.toString());
        }
        return !ModConfig.disallowedEnchantments.contains(identifier.toString());
    }

    public static boolean isEnchantmentAllowed(class_1887 enchantment) {
        return EnchancementUtil.isEnchantmentAllowed(class_7923.field_41176.method_10221((Object)enchantment));
    }

    public static boolean ignoreRecipe(class_8786<?> recipe) {
        return false;
    }

    public static boolean isGroundedOrAirborne(class_1309 living, boolean allowWater) {
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            if (player.method_31549().field_7479) {
                return false;
            }
        }
        if (!allowWater && (living.method_5799() || living.method_5681())) {
            return false;
        }
        return !living.method_6128() && living.method_5854() == null && !living.method_6101();
    }

    public static boolean isGroundedOrAirborne(class_1309 living) {
        return EnchancementUtil.isGroundedOrAirborne(living, false);
    }

    public static boolean isSubmerged(class_1297 entity, SubmersionGate gate) {
        for (int i = 0; i < class_3532.method_15386((float)entity.method_17682()); ++i) {
            class_2680 blockState = entity.method_37908().method_8320(entity.method_24515().method_10086(i));
            if (gate.allowsWater() && !blockState.method_27852(class_2246.field_10422) && blockState.method_26227().method_15767(ConventionalFluidTags.WATER)) {
                return true;
            }
            if (gate.allowsLava() && blockState.method_26227().method_15767(ConventionalFluidTags.LAVA)) {
                return true;
            }
            if (!gate.allowsPowderSnow() || !blockState.method_27852(class_2246.field_27879)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSufficientlyHigh(class_1297 entity, double distanceFromGround) {
        return entity.method_37908().method_17742(new class_3959(entity.method_19538(), entity.method_19538().method_1031(0.0, -distanceFromGround, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, entity)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean isDefaultEnchantment(class_1799 stack, class_1887 enchantment) {
        class_9304 defaultEnchantments = (class_9304)InitializeDefaultEnchantmentsEvent.DEFAULT_ENCHANTMENTS.get((Object)stack.method_7909());
        if (defaultEnchantments != null) {
            for (class_6880 foundEnchantment : defaultEnchantments.method_57534()) {
                int level;
                if (foundEnchantment.comp_349() != enchantment || (level = ModConfig.singleLevelMode ? 1 : class_1890.method_8225((class_1887)enchantment, (class_1799)stack)) != defaultEnchantments.method_57536(enchantment)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean limitCheck(boolean fallback, boolean value) {
        if (ModConfig.enchantmentLimit == 0) {
            return fallback;
        }
        return value;
    }

    public static int getNonDefaultEnchantmentsSize(class_1799 stack, int size) {
        for (class_6880 enchantment : class_1890.method_57532((class_1799)stack).method_57534()) {
            if (!EnchancementUtil.isDefaultEnchantment(stack, (class_1887)enchantment.comp_349())) continue;
            --size;
        }
        return size;
    }

    public static boolean shouldBeUnbreakable(class_1799 stack) {
        return ModConfig.disableDurability && !stack.method_7960() && stack.method_7936() > 0 && !stack.method_31573(ModItemTags.RETAINS_DURABILITY);
    }

    public static boolean shouldDisableLoyalty(class_1665 entity) {
        if (ModConfig.enchantedTridentsHaveLoyalty) {
            if (entity.method_5864().method_20210(ModEntityTypeTags.NO_LOYALTY)) {
                return true;
            }
            return !(entity.method_24921() instanceof class_1657);
        }
        return false;
    }

    public static boolean shouldHurt(class_1297 attacker, class_1297 hitEntity) {
        if (attacker == null || hitEntity == null) {
            return true;
        }
        if (attacker == hitEntity || attacker.method_5854() == hitEntity) {
            return false;
        }
        if (hitEntity instanceof class_1657) {
            class_1657 hitPlayer = (class_1657)hitEntity;
            if (attacker instanceof class_1657) {
                class_1657 attackingPlayer = (class_1657)attacker;
                return attackingPlayer.method_7256(hitPlayer);
            }
        }
        if (hitEntity instanceof class_8046) {
            class_8046 ownable = (class_8046)hitEntity;
            return EnchancementUtil.shouldHurt(attacker, ownable.method_24921());
        }
        return true;
    }

    public static float capMovementMultiplier(float multiplier) {
        return Math.min(4.0f, multiplier);
    }

    public static float getMaxBonusBerserkDamage(class_1799 stack, int level) {
        if (stack.method_57826(class_9334.field_49636)) {
            float divisor = 2.0f / (float)level;
            if ((double)divisor <= 0.001) {
                return 2.1474836E9f;
            }
            float maxBonus = 1.0f;
            for (class_9285.class_9287 entry : ((class_9285)stack.method_57824(class_9334.field_49636)).comp_2393()) {
                if (entry.comp_2395() != class_5134.field_23721 || !entry.comp_2397().method_57286(class_1304.field_6173)) continue;
                maxBonus += (float)(entry.comp_2396().comp_2449() / (double)divisor);
            }
            return maxBonus / 2.0f;
        }
        return 0.0f;
    }

    public static float getBonusBerserkDamage(class_1309 living, class_1799 stack) {
        int level;
        if (living != null && (level = class_1890.method_8225((class_1887)ModEnchantments.BERSERK, (class_1799)stack)) > 0) {
            float health = living.method_6063() - 1.0f;
            float bonus = 0.0f;
            while (health > living.method_6032()) {
                health -= 2.0f;
                bonus += (float)level * 0.25f;
            }
            return Math.min(bonus, EnchancementUtil.getMaxBonusBerserkDamage(stack, level));
        }
        return 0.0f;
    }

    public static int getModifiedMaxLevel(class_1799 stack, int maxLevel) {
        if (EnchancementUtil.hasWeakEnchantments(stack)) {
            return class_3532.method_15386((float)((float)maxLevel / 2.0f));
        }
        return maxLevel;
    }

    public static int getOriginalMaxLevel(class_1887 enchantment) {
        return ORIGINAL_MAX_LEVELS.getOrDefault((Object)enchantment, enchantment.method_8183());
    }

    public static int alterLevel(class_1799 stack, class_1887 enchantment, int additionalMax) {
        return EnchancementUtil.getModifiedMaxLevel(stack, EnchancementUtil.getOriginalMaxLevel(enchantment) + additionalMax);
    }

    public static int alterLevel(class_1799 stack, class_1887 enchantment) {
        return EnchancementUtil.alterLevel(stack, enchantment, 0);
    }

    public static int getBrimstoneDamage(float progress) {
        return (int)(6.0f * progress) * 2;
    }

    public static void tickPacketImmunities() {
        PACKET_IMMUNITIES.object2IntEntrySet().removeIf(entry -> entry.setValue(entry.getIntValue() - 1) <= 0);
    }
}

