/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.mixin.bouncy;

import moriyashiine.enchancement.common.component.entity.AirMobilityComponent;
import moriyashiine.enchancement.common.component.entity.BouncyComponent;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private static final class_2388 SLIME_PARTICLE = new class_2388(class_2398.field_11217, class_2246.field_10030.method_9564());

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyArg(method={"fall"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;spawnParticles(Lnet/minecraft/particle/ParticleEffect;DDDIDDDD)I"))
    private <T extends class_2394> T enchancement$bouncy(T value) {
        if (EnchancementUtil.hasEnchantment(ModEnchantments.BOUNCY, this)) {
            return (T)SLIME_PARTICLE;
        }
        return value;
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void enchancement$bouncy(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (!damageSource.method_49708(class_8111.field_42355) && fallDistance > (float)this.method_5850() && EnchancementUtil.hasEnchantment(ModEnchantments.BOUNCY, this)) {
            this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14560, this.method_5634(), 1.0f, 1.0f);
            if (!this.method_21750()) {
                ((AirMobilityComponent)ModEntityComponents.AIR_MOBILITY.get((Object)this)).enableResetBypass();
                BouncyComponent bouncyComponent = (BouncyComponent)ModEntityComponents.BOUNCY.getNullable((Object)this);
                if (bouncyComponent != null && bouncyComponent.grappleTimer > 0) {
                    fallDistance = 30.0f;
                }
                double bounceStrength = Math.log(fallDistance / 7.0f + 1.0f) / Math.log(1.05) / 16.0;
                this.method_18800(this.method_18798().method_10216(), bounceStrength, this.method_18798().method_10215());
                this.field_6037 = true;
            }
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyArg(method={"jump"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V"), index=1)
    private double enchancement$bouncy(double value) {
        float boostProgress;
        BouncyComponent bouncyComponent = (BouncyComponent)ModEntityComponents.BOUNCY.getNullable((Object)this);
        if (bouncyComponent != null && bouncyComponent.hasBouncy() && (boostProgress = bouncyComponent.getBoostProgress()) > 0.0f) {
            if (!this.method_37908().field_9236) {
                this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14560, this.method_5634(), 1.0f, 1.0f);
                ((class_3218)this.method_37908()).method_14199((class_2394)SLIME_PARTICLE, this.method_23317(), this.method_23318(), this.method_23321(), 32, 0.0, 0.0, 0.0, (double)0.15f);
            }
            return value + (double)(boostProgress * (float)bouncyComponent.getBouncyLevel());
        }
        return value;
    }
}

