/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.main;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableLink;
import com.lothrazar.storagenetwork.block.main.NetworkCache;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.Batch;
import com.lothrazar.storagenetwork.util.RequestBatch;
import com.lothrazar.storagenetwork.util.StackProvider;
import com.lothrazar.storagenetwork.util.UtilInventory;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.items.ItemHandlerHelper;

public class NetworkModule {
    NetworkCache ch = new NetworkCache();
    private Set<DimPos> connectables = new HashSet<DimPos>();
    private boolean shouldRefresh = true;

    public Set<IConnectable> getConnectables() {
        HashSet<DimPos> positions = new HashSet<DimPos>(this.connectables);
        HashSet<IConnectable> result = new HashSet<IConnectable>();
        for (DimPos pos : positions) {
            BlockEntity tileEntity;
            if (!pos.isLoaded() || (tileEntity = pos.getTileEntity(BlockEntity.class)) == null) continue;
            IConnectable cap = (IConnectable)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
            if (cap == null) {
                StorageNetworkMod.LOGGER.info("Somehow stored a dimpos that is not connectable... Skipping " + pos);
                continue;
            }
            result.add(cap);
        }
        return result;
    }

    public List<ItemStack> getStacks() {
        return this.getStacks(true);
    }

    public List<ItemStack> getStacks(boolean isFiltered) {
        this.selfValidate();
        ArrayList stacks = Lists.newArrayList();
        try {
            for (IConnectableLink storage : this.getConnectableStorage()) {
                for (ItemStack stack : storage.getStoredStacks(isFiltered)) {
                    if (stack == null || stack.m_41619_()) continue;
                    UtilTileEntity.addOrMergeIntoList(stacks, stack);
                }
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        return stacks;
    }

    public List<ItemStack> getSortedStacks() {
        this.selfValidate();
        boolean isFiltered = true;
        ArrayList stacks = Lists.newArrayList();
        try {
            for (IConnectableLink storage : this.getSortedConnectableStorage()) {
                for (ItemStack stack : storage.getStoredStacks(isFiltered)) {
                    if (stack == null || stack.m_41619_()) continue;
                    UtilTileEntity.addOrMergeIntoList(stacks, stack);
                }
            }
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        return stacks;
    }

    public int getAmount(ItemStackMatcher filter) {
        if (filter == null) {
            return 0;
        }
        int totalCount = 0;
        for (ItemStack stack : this.getStacks()) {
            if (!filter.match(stack)) continue;
            totalCount += stack.m_41613_();
        }
        return totalCount;
    }

    public void doRefresh(DimPos masterPos) {
        try {
            this.connectables = this.getConnectables(masterPos);
            this.shouldRefresh = false;
            masterPos.getWorld().m_46865_(masterPos.getBlockPos()).m_8092_(true);
        }
        catch (Throwable e) {
            StorageNetworkMod.LOGGER.info("Refresh network error ", e);
        }
    }

    public boolean shouldRefresh() {
        return this.shouldRefresh;
    }

    public void setShouldRefresh() {
        this.shouldRefresh = true;
    }

    public int getConnectableSize() {
        return this.connectables == null ? 0 : this.connectables.size();
    }

    public int emptySlots() {
        int countEmpty = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            countEmpty += storage.getEmptySlots();
        }
        return countEmpty;
    }

    public int insertStack(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return 0;
        }
        String key = UtilInventory.getStackKey(stack);
        if (this.ch.hasCachedSlot(stack)) {
            DimPos cachedStoragePos = this.ch.getCachedSlot(stack);
            IConnectableLink storage = cachedStoragePos.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null);
            if (storage == null) {
                this.ch.remove(key);
            } else {
                boolean canStillImport = storage.getSupportedTransferDirection().match(EnumStorageDirection.IN);
                if (canStillImport && storage.insertStack(stack, true).m_41613_() < stack.m_41613_()) {
                    stack = storage.insertStack(stack, simulate);
                    StorageNetworkMod.log("cache success used on a insertStack " + key);
                } else {
                    this.ch.remove(key);
                }
            }
        }
        if (stack.m_41619_()) {
            return 0;
        }
        List<IConnectableLink> storages = this.getSortedConnectableStorage();
        for (IConnectableLink storage : storages) {
            try {
                if (!storage.getSupportedTransferDirection().match(EnumStorageDirection.IN) || storage.insertStack(stack, true).m_41613_() >= stack.m_41613_()) continue;
                stack = storage.insertStack(stack, simulate);
                this.ch.put(key, storage.getPos());
            }
            catch (Exception e) {
                StorageNetworkMod.LOGGER.error("insertStack container issue", (Throwable)e);
            }
        }
        return stack.m_41613_();
    }

    public ItemStack request(ItemStackMatcher matcher, int size, boolean simulate) {
        if (size == 0 || matcher == null) {
            return ItemStack.f_41583_;
        }
        ItemStackMatcher usedMatcher = matcher;
        int alreadyTransferred = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            int req;
            ItemStack simExtract = storage.extractStack(usedMatcher, req = size - alreadyTransferred, simulate);
            if (simExtract.m_41619_()) continue;
            usedMatcher = new ItemStackMatcher(simExtract, matcher.isOre(), matcher.isNbt());
            if ((alreadyTransferred += simExtract.m_41613_()) < size) continue;
            break;
        }
        if (alreadyTransferred <= 0) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)usedMatcher.getStack(), (int)alreadyTransferred);
    }

    public void executeRequestBatch(RequestBatch batch) {
        Batch<StackProvider> availableItems = new Batch<StackProvider>();
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            storage.addToStackProviderBatch(availableItems);
        }
        for (Item item : batch.keySet()) {
            List availableStacks = (List)availableItems.get(item);
            if (availableStacks == null) continue;
            for (StackProvider provider : availableStacks) {
                batch.extractStacks(provider.getStorage(), provider.getSlot(), item);
            }
        }
    }

    public List<Map.Entry<String, Integer>> getDisplayStrings() {
        HashMap<String, Integer> mapNamesToCount = new HashMap<String, Integer>();
        for (DimPos p : new HashSet<DimPos>(this.connectables)) {
            Block bl = p.getBlockState().m_60734_();
            String blockName = Component.m_237113_((String)bl.m_7705_()).getString();
            int count = mapNamesToCount.get(blockName) != null ? (Integer)mapNamesToCount.get(blockName) + 1 : 1;
            mapNamesToCount.put(blockName, count);
        }
        ArrayList listDisplayStrings = Lists.newArrayList();
        for (Map.Entry e : mapNamesToCount.entrySet()) {
            listDisplayStrings.add(e);
        }
        Collections.sort(listDisplayStrings, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return Integer.compare(o2.getValue(), o1.getValue());
            }
        });
        return listDisplayStrings;
    }

    private void addConnectables(DimPos sourcePos, Set<DimPos> set, DimPos masterPos) {
        if (sourcePos == null || sourcePos.getWorld() == null || !sourcePos.isLoaded()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IConnectable capabilityConnectable;
            ChunkAccess chunk;
            DimPos lookPos = sourcePos.offset(direction);
            if (!lookPos.isLoaded() || (chunk = lookPos.getChunk()) == null) continue;
            TileMain maybeMain = lookPos.getTileEntity(TileMain.class);
            if (maybeMain != null && !lookPos.equals(masterPos.getWorld(), masterPos.getBlockPos())) {
                UtilInventory.nukeAndDrop(lookPos);
                continue;
            }
            BlockEntity tileHere = lookPos.getTileEntity(BlockEntity.class);
            if (tileHere == null || (capabilityConnectable = (IConnectable)tileHere.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, direction.m_122424_()).orElse(null)) == null) continue;
            if (capabilityConnectable.getPos() == null) {
                capabilityConnectable.setPos(lookPos);
                capabilityConnectable.setMainPos(masterPos);
            }
            if (capabilityConnectable == null) continue;
            capabilityConnectable.setMainPos(masterPos);
            DimPos realConnectablePos = capabilityConnectable.getPos();
            boolean beenHereBefore = set.contains(realConnectablePos);
            if (beenHereBefore) continue;
            if (realConnectablePos.getWorld() == null) {
                realConnectablePos.setWorld(sourcePos.getWorld());
            }
            set.add(realConnectablePos);
            this.addConnectables(realConnectablePos, set, masterPos);
            tileHere.m_6596_();
            chunk.m_8092_(true);
        }
    }

    private List<IConnectableLink> getSortedConnectableStorage() {
        try {
            Set<IConnectableLink> storage = this.getConnectableStorage();
            Stream stream = storage.stream();
            List<IConnectableLink> sorted = stream.sorted(Comparator.comparingInt(IConnectableLink::getPriority)).collect(Collectors.toList());
            return sorted;
        }
        catch (Exception e) {
            StorageNetworkMod.LOGGER.error("Error: network get sorted by priority error, some network components are disconnected ", (Throwable)e);
            return new ArrayList<IConnectableLink>();
        }
    }

    private Set<IConnectableLink> getConnectableStorage() {
        HashSet<DimPos> conSet = new HashSet<DimPos>(this.connectables);
        HashSet<IConnectableLink> result = new HashSet<IConnectableLink>();
        for (DimPos dimpos : conSet) {
            IConnectableLink capConnect;
            BlockEntity tileEntity;
            if (!dimpos.isLoaded() || (tileEntity = dimpos.getTileEntity(BlockEntity.class)) == null || (capConnect = (IConnectableLink)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null).orElse(null)) == null) continue;
            result.add(capConnect);
        }
        return result;
    }

    private Set<DimPos> getConnectables(DimPos masterPos) {
        HashSet<DimPos> result = new HashSet<DimPos>();
        this.addConnectables(masterPos, result, masterPos);
        return result;
    }

    private void selfValidate() {
        if (this.connectables == null) {
            this.setShouldRefresh();
        }
    }
}

