/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability.handler;

import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemStackMatcher
implements IItemStackMatcher {
    private ItemStack stack;
    private boolean ore;
    private boolean nbt;

    public ItemStackMatcher(ItemStack stack) {
        this(stack, false, false);
    }

    public ItemStackMatcher(ItemStack stack, boolean ore, boolean nbt) {
        this.stack = stack;
        this.ore = ore;
        this.nbt = nbt;
    }

    private ItemStackMatcher() {
    }

    public void readFromNBT(CompoundTag compound) {
        CompoundTag c = (CompoundTag)compound.m_128423_("stack");
        this.stack = ItemStack.m_41712_((CompoundTag)c);
        this.ore = compound.m_128471_("ore");
        this.nbt = compound.m_128471_("nbt");
    }

    public CompoundTag writeToNBT(CompoundTag compound) {
        CompoundTag c = new CompoundTag();
        this.stack.m_41739_(c);
        compound.m_128365_("stack", (Tag)c);
        compound.m_128379_("ore", this.ore);
        compound.m_128379_("nbt", this.nbt);
        return c;
    }

    public String toString() {
        return "ItemStackMatcher [stack=" + this.stack + ", ore=" + this.ore + ", nbt=" + this.nbt + "]";
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean isOre() {
        return this.ore;
    }

    public void setOre(boolean ore) {
        this.ore = ore;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public void setNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public static ItemStackMatcher loadFilterItemFromNBT(CompoundTag nbt) {
        ItemStackMatcher fil = new ItemStackMatcher();
        fil.readFromNBT(nbt);
        return fil.getStack() != null && fil.getStack().m_41720_() != null ? fil : null;
    }

    @Override
    public boolean match(ItemStack stackIn) {
        if (stackIn.m_41619_()) {
            return false;
        }
        if (this.nbt && !ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)stackIn)) {
            return false;
        }
        return stackIn.m_41720_() == this.stack.m_41720_();
    }

    @Override
    public boolean match(IItemStackMatcher matcher) {
        ItemStack stack = matcher.getStack();
        return this.match(stack);
    }
}

