/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.jei;

import com.lothrazar.storagenetwork.jei.JeiPlugin;
import com.mojang.blaze3d.platform.InputConstants;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IJeiKeyMappings;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;

public class JeiHooks {
    private static boolean isJeiLoaded() {
        return ModList.get().isLoaded("jei");
    }

    private static IJeiRuntime getRuntime() {
        if (!JeiHooks.isJeiLoaded()) {
            return null;
        }
        try {
            return JeiPlugin.runtime;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void testJeiKeybind(InputConstants.Key keyCode, ItemStack stackUnderMouse) {
        try {
            if (!JeiHooks.isJeiLoaded() || JeiHooks.getRuntime() == null) {
                return;
            }
            if (stackUnderMouse.m_150930_(Items.f_41852_)) {
                return;
            }
            IJeiKeyMappings keys = JeiHooks.getRuntime().getKeyMappings();
            boolean showRecipe = keys.getShowRecipe().isActiveAndMatches(keyCode);
            boolean showUses = keys.getShowUses().isActiveAndMatches(keyCode);
            if (showRecipe || showUses) {
                IRecipesGui gui = JeiHooks.getRuntime().getRecipesGui();
                IJeiHelpers helpers = JeiHooks.getRuntime().getJeiHelpers();
                RecipeIngredientRole mode = showRecipe ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT;
                IFocus focus = helpers.getFocusFactory().createFocus(mode, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stackUnderMouse);
                gui.show(focus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

