/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class UtilTileEntity {
    private static final Map<Item, String> modNamesForIds = new HashMap<Item, String>();
    public static final int MOUSE_BTN_LEFT = 0;
    public static final int MOUSE_BTN_RIGHT = 1;
    public static final int MOUSE_BTN_MIDDLE_CLICK = 2;

    public static void addOrMergeIntoList(List<ItemStack> list, ItemStack stackToAdd) {
        boolean added = false;
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackToAdd, (ItemStack)stack)) continue;
            stack.m_41764_(stack.m_41613_() + stackToAdd.m_41613_());
            added = true;
            break;
        }
        if (!added) {
            list.add(stackToAdd);
        }
    }

    public static void playSoundFromServer(ServerPlayer entityIn, SoundEvent soundIn, float volume) {
        if (soundIn == null || entityIn == null) {
            return;
        }
        entityIn.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ForgeRegistries.SOUND_EVENTS.getHolder((Object)soundIn).get(), SoundSource.PLAYERS, entityIn.f_19790_, entityIn.f_19791_, entityIn.f_19792_, volume, 1.0f, 0L));
    }

    public static void chatMessage(Player player, String message) {
        if (player.m_9236_().f_46443_) {
            player.m_213846_((Component)Component.m_237115_((String)message));
        }
    }

    public static void statusMessage(Player player, BlockState bs) {
        if (player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)bs.m_60734_().m_49954_().getString()), true);
        }
    }

    public static void statusMessage(Player player, String message) {
        if (player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)message), true);
        }
    }

    public static String lang(String message) {
        return Component.m_237115_((String)message).getString();
    }

    public static TileMain getTileMainForConnectable(IConnectable connectable) {
        if (connectable == null || connectable.getMainPos() == null) {
            return null;
        }
        return connectable.getMainPos().getTileEntity(TileMain.class);
    }

    public static String getModNameForItem(Item theitem) {
        if (modNamesForIds.containsKey(theitem)) {
            return modNamesForIds.get(theitem);
        }
        String modId = ForgeRegistries.ITEMS.getKey((Object)theitem).m_135827_();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        modNamesForIds.put(theitem, lowercaseModId);
        return lowercaseModId;
    }
}

