/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.network.StackResponseClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class InsertMessage {
    private int dim;
    private int mouseButton;

    public InsertMessage(int dim, int buttonID) {
        this.dim = dim;
        this.mouseButton = buttonID;
    }

    private InsertMessage() {
    }

    public static void handle(InsertMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileMain root = null;
            if (player.f_36096_ instanceof ContainerNetwork) {
                root = ((ContainerNetwork)player.f_36096_).getTileMain();
            }
            ItemStack send = ItemStack.f_41583_;
            ItemStack stack = player.f_36096_.m_142621_();
            if (message.mouseButton == 0) {
                int rest = root.insertStack(stack, false);
                if (rest != 0) {
                    send = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)rest);
                }
            } else if (message.mouseButton == 1) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                stack.m_41774_(1);
                int rest = root.insertStack(stack1, false) + stack.m_41613_();
                if (rest != 0) {
                    send = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)rest);
                }
            }
            player.f_36096_.m_142503_(send);
            PacketRegistry.INSTANCE.sendTo((Object)new StackResponseClientMessage(send), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            List<ItemStack> list = root.nw.getStacks();
            PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            player.f_36096_.m_38946_();
        });
        ctx.get().setPacketHandled(true);
    }

    public static InsertMessage decode(FriendlyByteBuf buf) {
        InsertMessage message = new InsertMessage();
        message.dim = buf.readInt();
        message.mouseButton = buf.readInt();
        return message;
    }

    public static void encode(InsertMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.dim);
        buf.writeInt(msg.mouseButton);
    }
}

