/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable;

import java.util.List;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.capability.IConnectable;
import mrriegel.storagenetwork.block.AbstractBlockConnectable;
import mrriegel.storagenetwork.block.cable.BlockAccessFacade;
import mrriegel.storagenetwork.block.cable.TileCable;
import mrriegel.storagenetwork.block.cable.UnlistedPropertyBlockNeighbors;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.config.ConfigHandler;
import mrriegel.storagenetwork.gui.GuiHandler;
import mrriegel.storagenetwork.network.CableFacadeMessage;
import mrriegel.storagenetwork.registry.ModBlocks;
import mrriegel.storagenetwork.registry.PacketRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCable
extends AbstractBlockConnectable {
    public static final UnlistedPropertyBlockNeighbors BLOCK_NEIGHBORS = new UnlistedPropertyBlockNeighbors();

    public BlockCable(String registryName) {
        super(Material.field_151576_e, registryName);
        this.func_149711_c(1.4f);
        this.func_149647_a(CreativeTab.tab);
    }

    public static TileCable getTileCable(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCable) {
            return (TileCable)tile;
        }
        return null;
    }

    protected TileEntity getTileEntityNoUpdate(IBlockAccess world, BlockPos pos) {
        if (!(world instanceof World)) {
            return world.func_175625_s(pos);
        }
        TileEntity tile = ((World)world).func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        return tile;
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{BLOCK_NEIGHBORS};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    protected UnlistedPropertyBlockNeighbors.BlockNeighbors getBlockNeighbors(IBlockAccess world, BlockPos pos) {
        UnlistedPropertyBlockNeighbors.BlockNeighbors blockNeighbors = new UnlistedPropertyBlockNeighbors.BlockNeighbors();
        for (EnumFacing facing : EnumFacing.values()) {
            TileMaster tileMaster = this.getClientSideTileEntity(world, pos.func_177972_a(facing), TileMaster.class);
            IConnectable connectable = this.getClientSideCapability(world, pos.func_177972_a(facing), StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null);
            if (connectable == null && tileMaster == null) continue;
            blockNeighbors.setNeighborType(facing, UnlistedPropertyBlockNeighbors.EnumNeighborType.CABLE);
        }
        return blockNeighbors;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        return extendedBlockState.withProperty((IUnlistedProperty)BLOCK_NEIGHBORS, (Object)this.getBlockNeighbors(world, pos));
    }

    @Nullable
    public <V> V getClientSideTileEntity(IBlockAccess world, BlockPos pos, Class<V> tileEntityClassOrInterface) {
        TileEntity tileEntity = this.getTileEntityNoUpdate(world, pos);
        if (tileEntity == null) {
            return null;
        }
        if (!tileEntityClassOrInterface.isAssignableFrom(tileEntity.getClass())) {
            return null;
        }
        return (V)tileEntity;
    }

    @Nullable
    private <V> V getClientSideCapability(IBlockAccess world, BlockPos pos, Capability<V> capability, EnumFacing side) {
        TileEntity tileEntity = this.getTileEntityNoUpdate(world, pos);
        if (tileEntity == null) {
            return null;
        }
        if (!tileEntity.hasCapability(capability, side)) {
            return null;
        }
        return (V)tileEntity.getCapability(capability, side);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCable();
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        TileCable tile = BlockCable.getTileCable(world, pos);
        if (tile != null && tile.getFacadeState() != null) {
            return tile.getFacadeState().func_193401_d((IBlockAccess)new BlockAccessFacade(world), pos, side);
        }
        return BlockFaceShape.MIDDLE_POLE_THIN;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TileCable tile = BlockCable.getTileCable(world, pos);
        if (tile != null && tile.getFacadeState() != null) {
            return tile.getFacadeState().func_177230_c().canBeConnectedTo((IBlockAccess)new BlockAccessFacade(world), pos, facing);
        }
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileCable tile = BlockCable.getTileCable(world, pos);
        if (tile != null && tile.getFacadeState() != null) {
            return tile.getFacadeState().isSideSolid((IBlockAccess)new BlockAccessFacade(world), pos, side);
        }
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileCable tile = BlockCable.getTileCable(world, pos);
        if (tile != null && tile.getFacadeState() != null) {
            return tile.getFacadeState().doesSideBlockRendering((IBlockAccess)new BlockAccessFacade(world), pos, face);
        }
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileCable tile = BlockCable.getTileCable((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return false;
        }
        if (tile.func_145838_q() == ModBlocks.exKabel) {
            playerIn.openGui((Object)StorageNetwork.instance, GuiHandler.GuiIDs.EXPORT.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (tile.func_145838_q() == ModBlocks.imKabel) {
            playerIn.openGui((Object)StorageNetwork.instance, GuiHandler.GuiIDs.IMPORT.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (tile.func_145838_q() == ModBlocks.storageKabel) {
            playerIn.openGui((Object)StorageNetwork.instance, GuiHandler.GuiIDs.LINK.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (tile.func_145838_q() == ModBlocks.processKabel) {
            playerIn.openGui((Object)StorageNetwork.instance, GuiHandler.GuiIDs.PROCESSING.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            StorageNetwork.log("client only ahead");
            return;
        }
        if (!playerIn.func_70093_af()) {
            StorageNetwork.log("no sneak");
            return;
        }
        ItemStack heldStack = playerIn.func_184614_ca();
        TileCable tile = BlockCable.getTileCable((IBlockAccess)worldIn, pos);
        if (tile == null) {
            StorageNetwork.log("no tile");
            return;
        }
        if (heldStack == null || heldStack.func_190926_b()) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableFacadeMessage(pos, true));
            worldIn.func_180497_b(pos, tile.func_145838_q(), 1, 1);
            worldIn.markAndNotifyBlock(pos.func_185334_h(), worldIn.func_175726_f(pos), tile.func_145838_q().func_176223_P(), tile.func_145838_q().func_176223_P(), 3);
        } else {
            float f2;
            float f1;
            if (!ConfigHandler.isFacadeAllowed(heldStack)) {
                StorageNetwork.log("not allowed as a facade from config file");
                return;
            }
            Block block = Block.func_149634_a((Item)heldStack.func_77973_b());
            if (block == null || block == Blocks.field_150350_a) {
                StorageNetwork.log("no block");
                return;
            }
            int meta = heldStack.func_77960_j();
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            float f = (float)(mouseOver.field_72307_f.field_72450_a - (double)pos.func_177958_n());
            IBlockState state = block.func_180642_a(worldIn, pos, mouseOver.field_178784_b, f, f1 = (float)(mouseOver.field_72307_f.field_72448_b - (double)pos.func_177956_o()), f2 = (float)(mouseOver.field_72307_f.field_72449_c - (double)pos.func_177952_p()), meta, (EntityLivingBase)playerIn);
            if (state == null || state.func_185901_i() != EnumBlockRenderType.MODEL) {
                StorageNetwork.log("no model");
                return;
            }
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableFacadeMessage(pos, state));
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        TileCable tile = BlockCable.getTileCable((IBlockAccess)worldIn, pos);
        if (tile == null) {
            return;
        }
        if (ConfigHandler.facadesUseCollisionBoundingBox && tile.getFacadeState() != null) {
            tile.getFacadeState().func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
            return;
        }
        float f = 0.3125f;
        float f1 = 0.6875f;
        float f2 = 0.3125f;
        float f3 = 0.6875f;
        float f4 = 0.3125f;
        float f5 = 0.6875f;
        BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        UnlistedPropertyBlockNeighbors.BlockNeighbors neighbors = this.getBlockNeighbors((IBlockAccess)worldIn, pos);
        if (neighbors.north() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            f2 = 0.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (neighbors.south() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            f3 = 1.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (neighbors.west() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            f = 0.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (neighbors.east() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            f1 = 1.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (neighbors.down() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            f4 = 0.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
        if (neighbors.up() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            f5 = 1.0f;
            BlockCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB((double)f, (double)f4, (double)f2, (double)f1, (double)f5, (double)f3));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileCable tile;
        if (ConfigHandler.facadesUseCollisionBoundingBox && (tile = BlockCable.getTileCable(world, pos)) != null && tile.getFacadeState() != null) {
            return tile.getFacadeState().func_185900_c((IBlockAccess)new BlockAccessFacade(world), pos);
        }
        UnlistedPropertyBlockNeighbors.BlockNeighbors neighbors = this.getBlockNeighbors(world, pos);
        float x1 = 0.375f;
        float x2 = 0.625f;
        float y1 = 0.375f;
        float y2 = 0.625f;
        float z1 = 0.375f;
        float z2 = 0.625f;
        if (neighbors.north() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            y1 = 0.0f;
        }
        if (neighbors.south() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            y2 = 1.0f;
        }
        if (neighbors.west() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            x1 = 0.0f;
        }
        if (neighbors.east() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            x2 = 1.0f;
        }
        if (neighbors.down() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            z1 = 0.0f;
        }
        if (neighbors.up() != UnlistedPropertyBlockNeighbors.EnumNeighborType.NONE) {
            z2 = 1.0f;
        }
        return new AxisAlignedBB((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2);
    }

    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.exKabel)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_E", (Object[])new Object[0]));
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.imKabel)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_I", (Object[])new Object[0]));
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.storageKabel)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_S", (Object[])new Object[0]));
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.kabel)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_L", (Object[])new Object[0]));
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.processKabel)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.kabel_P", (Object[])new Object[0]));
        } else if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.simple_kabel)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.simple_kabel", (Object[])new Object[0]));
        }
    }
}

