/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable;

import mrriegel.storagenetwork.block.TileConnectable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TileCable
extends TileConnectable {
    private static final String NBT_META = "meta";
    private static final String NBT_BLOCK = "block";
    private static final String NBT_FACADE = "facade";
    private IBlockState facadeState = null;

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_FACADE)) {
            this.setFacadeState(null);
            NBTTagCompound facadeTag = compound.func_74775_l(NBT_FACADE);
            if (facadeTag.func_74764_b(NBT_BLOCK)) {
                Block facade = Block.func_149684_b((String)facadeTag.func_74779_i(NBT_BLOCK));
                this.setFacadeState(facade.func_176203_a(facadeTag.func_74762_e(NBT_META)));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound facadeTag = new NBTTagCompound();
        if (this.facadeState != null) {
            facadeTag.func_74778_a(NBT_BLOCK, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.getFacadeState().func_177230_c()).toString());
            facadeTag.func_74768_a(NBT_META, this.getFacadeState().func_177230_c().func_176201_c(this.getFacadeState()));
        }
        compound.func_74782_a(NBT_FACADE, (NBTBase)facadeTag);
        return compound;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtention = 1.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtention, (double)this.field_174879_c.func_177956_o() - renderExtention, (double)this.field_174879_c.func_177952_p() - renderExtention, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtention, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtention, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtention);
        return bb;
    }

    public IBlockState getFacadeState() {
        return this.facadeState;
    }

    public void setFacadeState(IBlockState facadeState) {
        this.facadeState = facadeState;
    }

    public void setFacadeState(String block, int meta) {
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block));
        this.facadeState = b.func_176203_a(meta);
    }
}

