/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.gui.IStorageContainer;
import mrriegel.storagenetwork.gui.InventoryCraftingNetwork;
import mrriegel.storagenetwork.network.StackRefreshClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class ContainerNetworkBase
extends Container
implements IStorageContainer {
    protected InventoryPlayer playerInv;
    protected InventoryCraftResult result;
    protected InventoryCraftingNetwork matrix;
    protected boolean recipeLocked = false;
    protected boolean isSimple;
    boolean test = false;

    @Override
    public InventoryCrafting getCraftMatrix() {
        return this.matrix;
    }

    @Override
    public abstract TileMaster getTileMaster();

    public abstract void bindHotbar();

    @Override
    public abstract void slotChanged();

    protected void bindPlayerInvo(InventoryPlayer playerInv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 174 + i * 18));
            }
        }
    }

    protected void bindGrid() {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new Slot((IInventory)this.matrix, index++, 8 + j * 18, 110 + i * 18));
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        this.slotChanged();
        super.func_75134_a(playerIn);
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
    }

    protected void findMatchingRecipe(InventoryCrafting craftMatrix) {
        IRecipe recipe = null;
        try {
            recipe = CraftingManager.func_192413_b((InventoryCrafting)this.matrix, (World)this.playerInv.field_70458_d.field_70170_p);
        }
        catch (NoSuchElementException err) {
            StorageNetwork.instance.logger.error("Error finding recipe [0] Possible conflict with forge, vanilla, or Storage Network", (Throwable)err);
        }
        catch (Throwable e) {
            StorageNetwork.instance.logger.error("Error finding recipe [-1]", e);
        }
        if (recipe != null) {
            ItemStack itemstack = recipe.func_77572_b((InventoryCrafting)this.matrix);
            this.result.func_70299_a(0, itemstack);
        } else {
            this.result.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    protected void craftShift(EntityPlayer player, TileMaster tile) {
        if (this.matrix == null) {
            return;
        }
        IRecipe recipeCurrent = CraftingManager.func_192413_b((InventoryCrafting)this.matrix, (World)player.field_70170_p);
        if (recipeCurrent == null) {
            return;
        }
        this.recipeLocked = true;
        int crafted = 0;
        ArrayList recipeCopy = Lists.newArrayList();
        for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
            recipeCopy.add(this.matrix.func_70301_a(i).func_77946_l());
        }
        ItemStack res = recipeCurrent.func_77572_b((InventoryCrafting)this.matrix);
        if (res.func_190926_b()) {
            return;
        }
        int sizePerCraft = res.func_190916_E();
        while (crafted + sizePerCraft <= res.func_77976_d() && ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerMainInvWrapper(this.playerInv), (ItemStack)(res = recipeCurrent.func_77572_b((InventoryCrafting)this.matrix)), (boolean)true).func_190926_b() && recipeCurrent.func_77569_a((InventoryCrafting)this.matrix, player.field_70170_p)) {
            if (!player.field_71071_by.func_70441_a(res)) {
                player.func_71019_a(res, false);
            }
            NonNullList remainder = CraftingManager.func_180303_b((InventoryCrafting)this.matrix, (World)player.field_70170_p);
            for (int i = 0; i < remainder.size(); ++i) {
                ItemStack remainderCurrent = (ItemStack)remainder.get(i);
                ItemStack slot = this.matrix.func_70301_a(i);
                if (remainderCurrent.func_190926_b()) {
                    this.matrix.func_70301_a(i).func_190918_g(1);
                    continue;
                }
                if (remainderCurrent.func_77951_h() && remainderCurrent.func_77952_i() > remainderCurrent.func_77958_k()) {
                    remainderCurrent = ItemStack.field_190927_a;
                }
                if (slot.func_77973_b().func_77668_q() != null) {
                    slot = new ItemStack(slot.func_77973_b().func_77668_q());
                    this.matrix.func_70299_a(i, slot);
                    continue;
                }
                if (!slot.func_77973_b().getContainerItem(slot).func_190926_b()) {
                    slot = slot.func_77973_b().getContainerItem(slot);
                    this.matrix.func_70299_a(i, slot);
                    continue;
                }
                if (!remainderCurrent.func_190926_b()) {
                    if (slot.func_190926_b()) {
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.func_179545_c((ItemStack)slot, (ItemStack)remainderCurrent) && ItemStack.func_77970_a((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        remainderCurrent.func_190917_f(slot.func_190916_E());
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (ItemStack.func_185132_d((ItemStack)slot, (ItemStack)remainderCurrent)) {
                        this.matrix.func_70299_a(i, remainderCurrent);
                        continue;
                    }
                    if (player.field_71071_by.func_70441_a(remainderCurrent)) continue;
                    player.func_71019_a(remainderCurrent, false);
                    continue;
                }
                if (slot.func_190926_b()) continue;
                this.matrix.func_70298_a(i, 1);
                slot = this.matrix.func_70301_a(i);
            }
            crafted += sizePerCraft;
            for (int i = 0; i < this.matrix.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.matrix.func_70301_a(i);
                if (!stackInSlot.func_190926_b()) continue;
                ItemStack recipeStack = (ItemStack)recipeCopy.get(i);
                ItemStackMatcher itemStackMatcherCurrent = !recipeStack.func_190926_b() ? new ItemStackMatcher(recipeStack, true, false, false) : null;
                ItemStack req = tile.request(itemStackMatcherCurrent, 1, false);
                this.matrix.func_70299_a(i, req);
            }
            this.func_75130_a((IInventory)this.matrix);
        }
        this.func_75142_b();
        this.recipeLocked = false;
        this.func_75130_a((IInventory)this.matrix);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int slotIndex) {
        if (playerIn.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            TileMaster tileMaster = this.getTileMaster();
            if (slotIndex == 0 && !this.isSimple) {
                this.craftShift(playerIn, tileMaster);
                return ItemStack.field_190927_a;
            }
            if (tileMaster != null) {
                int rest = tileMaster.insertStack(itemstack1, false);
                ItemStack stack = rest == 0 ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack1, (int)rest);
                slot.func_75215_d(stack);
                this.func_75142_b();
                List<ItemStack> list = tileMaster.getStacks();
                PacketRegistry.INSTANCE.sendTo((IMessage)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), (EntityPlayerMP)playerIn);
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public final class SlotCraftingNetwork
    extends SlotCrafting {
        private TileMaster tileMaster;

        public SlotCraftingNetwork(EntityPlayer player, InventoryCrafting craftingInventory, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
            super(player, craftingInventory, inventoryIn, slotIndex, xPosition, yPosition);
        }

        public ItemStack func_190901_a(EntityPlayer playerIn, ItemStack stack) {
            int i;
            if (playerIn.field_70170_p.field_72995_K) {
                return stack;
            }
            ArrayList lis = Lists.newArrayList();
            for (i = 0; i < ContainerNetworkBase.this.matrix.func_70302_i_(); ++i) {
                lis.add(ContainerNetworkBase.this.matrix.func_70301_a(i).func_77946_l());
            }
            super.func_190901_a(playerIn, stack);
            ContainerNetworkBase.this.func_75142_b();
            for (i = 0; i < ContainerNetworkBase.this.matrix.func_70302_i_(); ++i) {
                ItemStack req;
                if (!ContainerNetworkBase.this.matrix.func_70301_a(i).func_190926_b() || this.getTileMaster() == null || (req = this.getTileMaster().request(!((ItemStack)lis.get(i)).func_190926_b() ? new ItemStackMatcher((ItemStack)lis.get(i), true, false, false) : null, 1, false)).func_190926_b()) continue;
                ContainerNetworkBase.this.matrix.func_70299_a(i, req);
            }
            ContainerNetworkBase.this.func_75142_b();
            return stack;
        }

        public TileMaster getTileMaster() {
            return this.tileMaster;
        }

        public void setTileMaster(TileMaster tileMaster) {
            this.tileMaster = tileMaster;
        }
    }
}

