/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.gui.fb;

import java.util.ArrayList;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.gui.fb.ContainerFastNetworkCrafter;
import mrriegel.storagenetwork.item.remote.ItemRemote;
import mrriegel.storagenetwork.network.StackRefreshClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerFastRemote
extends ContainerFastNetworkCrafter {
    final ItemStack remoteItemStack;
    private final int remoteSlot;

    public ContainerFastRemote(EntityPlayer player, World world, int remoteSlot) {
        super(player, world, BlockPos.field_177992_a);
        this.remoteSlot = remoteSlot;
        this.remoteItemStack = player.field_71071_by.func_70301_a(remoteSlot);
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        for (int i = 0; i < 9; ++i) {
            if (i != 8) {
                this.field_75162_e.field_70466_a.set(i, (Object)NBTHelper.getItemStack(this.remoteItemStack, "c" + i));
                continue;
            }
            this.field_75162_e.func_70299_a(i, NBTHelper.getItemStack(this.remoteItemStack, "c" + i));
        }
        ContainerFastNetworkCrafter.SlotCraftingNetwork slotCraftOutput = new ContainerFastNetworkCrafter.SlotCraftingNetwork(player, this.field_75162_e, this.field_75160_f, 0, 101, 128);
        slotCraftOutput.setTileMaster(this.getTileMaster());
        this.func_75146_a((Slot)slotCraftOutput);
        this.bindGrid();
        this.bindPlayerInvo(player.field_71071_by);
        this.bindHotbar(player);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        TileMaster tileMaster = this.getTileMaster();
        if (tileMaster == null) {
            StorageNetwork.log("ContainerFastRemote closing, master tile not found " + this.remoteItemStack);
            return false;
        }
        if (!playerIn.field_70170_p.field_72995_K && (this.forceSync || playerIn.field_70170_p.func_82737_E() % 40L == 0L)) {
            this.forceSync = false;
            PacketRegistry.INSTANCE.sendTo((IMessage)new StackRefreshClientMessage(tileMaster.getStacks(), new ArrayList<ItemStack>()), (EntityPlayerMP)playerIn);
        }
        return playerIn.field_71071_by.func_70301_a(this.remoteSlot) == this.remoteItemStack;
    }

    @Override
    public void slotChanged() {
        if (this.field_75162_e != null) {
            for (int i = 0; i < 9; ++i) {
                NBTHelper.setItemStack(this.remoteItemStack, "c" + i, this.field_75162_e.func_70301_a(i));
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        if (!this.remoteItemStack.func_190926_b()) {
            for (int i = 0; i < 9; ++i) {
                NBTHelper.setItemStack(this.remoteItemStack, "c" + i, this.field_75162_e.func_70301_a(i));
            }
        }
    }

    @Override
    public TileMaster getTileMaster() {
        return ItemRemote.getTile(this.remoteItemStack);
    }

    @Override
    protected void bindPlayerInvo(InventoryPlayer playerInv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slot = j + i * 9 + 9;
                if (slot == this.remoteSlot) {
                    this.func_75146_a(new Slot((IInventory)playerInv, slot, 8 + j * 18, 174 + i * 18){

                        public boolean func_75214_a(ItemStack stack) {
                            return false;
                        }

                        public boolean func_82869_a(EntityPlayer playerIn) {
                            return false;
                        }
                    });
                    continue;
                }
                this.func_75146_a(new Slot((IInventory)playerInv, slot, 8 + j * 18, 174 + i * 18));
            }
        }
    }

    @Override
    public void bindHotbar(EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            if (i == this.remoteSlot) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 232){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 232));
        }
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    public static class Client
    extends ContainerFastRemote {
        public Client(EntityPlayer player, World world, int remoteSlot) {
            super(player, world, remoteSlot);
        }

        public void func_75130_a(IInventory inventoryIn) {
        }
    }
}

