/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.cable.BlockCable;
import mrriegel.storagenetwork.block.cable.TileCable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CableFacadeMessage
implements IMessage,
IMessageHandler<CableFacadeMessage, IMessage> {
    private BlockPos pos;
    private boolean erase = false;
    private String block = "";
    private int meta = 0;

    public CableFacadeMessage() {
    }

    public CableFacadeMessage(BlockPos pos, IBlockState state) {
        this.pos = pos;
        this.block = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.func_177230_c()).toString();
        this.meta = state.func_177230_c().func_176201_c(state);
    }

    public CableFacadeMessage(BlockPos pos, boolean eraseIn) {
        this.pos = pos;
        this.erase = eraseIn;
    }

    public IMessage onMessage(final CableFacadeMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        final World world = player.field_70170_p;
        WorldServer mainThread = (WorldServer)world;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                TileCable tile = BlockCable.getTileCable((IBlockAccess)world, message.pos);
                if (message.erase) {
                    StorageNetwork.log("unset facade ");
                    tile.setFacadeState(null);
                    world.markAndNotifyBlock(message.pos.func_185334_h(), world.func_175726_f(message.pos), tile.func_145838_q().func_176223_P(), tile.func_145838_q().func_176223_P(), 3);
                    tile.func_70296_d();
                } else {
                    StorageNetwork.log("set facade: " + message.block);
                    tile.setFacadeState(message.block, message.meta);
                    world.markAndNotifyBlock(message.pos.func_185334_h(), world.func_175726_f(message.pos), tile.func_145838_q().func_176223_P(), tile.func_145838_q().func_176223_P(), 3);
                    tile.func_70296_d();
                }
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.erase = buf.readBoolean();
        this.block = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.meta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.erase);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.block);
        buf.writeInt(this.meta);
    }
}

