/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.util.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mrriegel.storagenetwork.api.data.IItemStackMatcher;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.util.inventory.ItemStackHandlerEx;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FilterItemStackHandler
extends ItemStackHandlerEx {
    public static final int FILTER_SIZE = 18;
    public boolean ores = false;
    public boolean meta = true;
    public boolean nbt = false;
    public boolean isWhitelist = true;

    public FilterItemStackHandler() {
        this(18);
    }

    public FilterItemStackHandler(int size) {
        super(size);
    }

    public void setMatchOreDict(boolean ores) {
        this.ores = ores;
    }

    public void setMatchMeta(boolean meta) {
        this.meta = meta;
    }

    public void setMatchNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public void setIsWhitelist(boolean whitelist) {
        this.isWhitelist = whitelist;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 1;
    }

    public List<IItemStackMatcher> getStackMatchers() {
        List<ItemStack> storedStacks = this.getStacks();
        ArrayList<IItemStackMatcher> ret = new ArrayList<IItemStackMatcher>(storedStacks.size());
        for (ItemStack stack : storedStacks) {
            if (stack.func_190926_b()) continue;
            ret.add(new ItemStackMatcher(stack, this.meta, this.ores, this.nbt));
        }
        return ret;
    }

    public void clear() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public boolean exactStackAlreadyInList(ItemStack stack) {
        return this.getStackMatchers().stream().anyMatch(matcher -> matcher.match(stack));
    }

    public boolean isStackFiltered(ItemStack stack) {
        if (this.isWhitelist) {
            return this.getStackMatchers().stream().noneMatch(matcher -> matcher.match(stack));
        }
        return this.getStackMatchers().stream().anyMatch(matcher -> matcher.match(stack));
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        NBTTagCompound rulesTag = nbt.func_74775_l("rules");
        this.ores = rulesTag.func_74767_n("ores");
        this.meta = rulesTag.func_74767_n("meta");
        this.nbt = rulesTag.func_74767_n("nbt");
        this.isWhitelist = rulesTag.func_74767_n("whitelist");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = super.serializeNBT();
        NBTTagCompound rulesTag = new NBTTagCompound();
        rulesTag.func_74757_a("ores", this.ores);
        rulesTag.func_74757_a("meta", this.meta);
        rulesTag.func_74757_a("nbt", this.nbt);
        rulesTag.func_74757_a("whitelist", this.isWhitelist);
        result.func_74782_a("rules", (NBTBase)rulesTag);
        return result;
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b()) continue;
            result.add(stack);
        }
        return result;
    }

    public List<ItemStack> getOutputs() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 9; slot < 18; ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack == null || stack.func_190926_b()) continue;
            result.add(stack);
        }
        return result;
    }

    public boolean isOutputEmpty() {
        return this.getOutputs().isEmpty();
    }

    public boolean isInputEmpty() {
        return this.getInputs().isEmpty();
    }
}

