/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dylanvhs.bountiful_critters.entity.client.LionModel;
import net.dylanvhs.bountiful_critters.entity.custom.LionEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class LionRenderer
extends GeoEntityRenderer<LionEntity> {
    private static final ResourceLocation DEFAULT = new ResourceLocation("bountiful_critters", "textures/entity/lion/lion0.png");
    private static final ResourceLocation WHITE = new ResourceLocation("bountiful_critters", "textures/entity/lion/lion1.png");
    private static final ResourceLocation ARMORED = new ResourceLocation("bountiful_critters", "textures/entity/lion/lion_armor.png");
    private static final ResourceLocation ARMOR_LAYER = new ResourceLocation("bountiful_critters", "textures/entity/lion/lion_armor_layer.png");
    private static final ResourceLocation ARMOR_LAYER_SLIGHTLY_DAMAGED = new ResourceLocation("bountiful_critters", "textures/entity/lion/lion_armor_layer_slightly_damaged.png");
    private static final ResourceLocation ARMOR_LAYER_DAMAGED = new ResourceLocation("bountiful_critters", "textures/entity/lion/lion_armor_layer_damaged.png");

    public LionRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new LionModel());
        this.addRenderLayer(new LionArmorLayer((GeoRenderer<LionEntity>)this));
    }

    public ResourceLocation getTextureLocation(LionEntity animatable) {
        return switch (animatable.getVariant()) {
            case 1 -> WHITE;
            default -> DEFAULT;
        };
    }

    public void render(LionEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public static class LionArmorLayer
    extends GeoRenderLayer<LionEntity> {
        public LionArmorLayer(GeoRenderer<LionEntity> renderer) {
            super(renderer);
        }

        protected RenderType getRenderType(LionEntity animatable) {
            if (animatable.isArmorRepaired() && !animatable.isArmorDamaged() && !animatable.isArmorSlightlyDamaged() && animatable.armorDurability > 128) {
                return RenderType.m_110452_((ResourceLocation)ARMOR_LAYER);
            }
            if (animatable.isArmorSlightlyDamaged() && !animatable.isArmorDamaged() && !animatable.isArmorRepaired()) {
                return RenderType.m_110452_((ResourceLocation)ARMOR_LAYER_SLIGHTLY_DAMAGED);
            }
            if (animatable.isArmorDamaged() && !animatable.isArmorSlightlyDamaged() && !animatable.isArmorRepaired()) {
                return RenderType.m_110452_((ResourceLocation)ARMOR_LAYER_DAMAGED);
            }
            return RenderType.m_110452_((ResourceLocation)ARMOR_LAYER);
        }

        public void render(PoseStack poseStack, LionEntity animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (animatable.isArmored()) {
                renderType = this.getRenderType(animatable);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.m_6299_(renderType), partialTick, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

