/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.ai.FleeSkyGoal;
import net.dylanvhs.bountiful_critters.entity.custom.LionEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HogbearEntity
extends Animal
implements Enemy,
GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(HogbearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(HogbearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_SLEEPING = 32;

    public HogbearEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = new HogbearLookControl();
        this.f_21342_ = new HogbearMoveControl();
    }

    public static AttributeSupplier setAttributes() {
        return LionEntity.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HogbearFloatGoal());
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SkeletonHorse.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Hoglin.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(7, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(12, (Goal)new HogbearLookAtPlayerGoal((Mob)this, Player.class, 24.0f));
        this.f_21345_.m_25352_(6, (Goal)new SeekShelterGoal(1.25));
    }

    protected boolean onSoulSandBlock() {
        return this.m_9236_().m_8055_(this.m_20099_()).m_60713_(Blocks.f_50135_);
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            this.m_6858_(this.m_5912_());
            this.m_21051_(Attributes.f_22279_).m_22100_(this.onSoulSandBlock() ? 0.3 : 0.2);
        }
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        super.m_8107_();
    }

    protected boolean m_6107_() {
        return this.m_21224_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Sleeping", this.m_5803_());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setSleeping(pCompound.m_128471_("Sleeping"));
    }

    public boolean m_5803_() {
        return this.getFlag(32);
    }

    void setSleeping(boolean pSleeping) {
        this.setFlag(32, pSleeping);
    }

    private void setFlag(int pFlagId, boolean pValue) {
        if (pValue) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | pFlagId)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~pFlagId)));
        }
    }

    private boolean getFlag(int pFlagId) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & pFlagId) != 0;
    }

    public void m_8119_() {
        boolean flag;
        super.m_8119_();
        if (this.m_21515_() && ((flag = this.m_20069_()) || this.m_5448_() != null || this.m_9236_().m_46470_())) {
            this.wakeUp();
        }
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setSleeping(false);
    }

    boolean canMove() {
        return !this.m_5803_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.HOGBEAR_SPAWN_EGG.get());
    }

    @Nullable
    public HogbearEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (HogbearEntity)((EntityType)ModEntities.HOGBEAR.get()).m_20615_((Level)pLevel);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42583_);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.95f : 1.7f;
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50135_) || blockstate.m_60713_(Blocks.f_50136_);
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.m_6162_()) {
            return false;
        }
        return prev;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 4, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (geoAnimatableAnimationState.isMoving() && !this.m_20142_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.hogbear.walk", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving() && this.m_20142_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.hogbear.sprint", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        if (this.m_5803_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.hogbear.sleep", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.hogbear.idle", Animation.LoopType.LOOP));
        geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.f_20911_ && geoAnimatableAnimationState.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            geoAnimatableAnimationState.getController().forceAnimationReset();
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.hogbear.attack", Animation.LoopType.PLAY_ONCE));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.5);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    public class HogbearLookControl
    extends LookControl {
        public HogbearLookControl() {
            super((Mob)HogbearEntity.this);
        }

        public void m_8128_() {
            if (!HogbearEntity.this.m_5803_()) {
                super.m_8128_();
            }
        }
    }

    class HogbearMoveControl
    extends MoveControl {
        public HogbearMoveControl() {
            super((Mob)HogbearEntity.this);
        }

        public void m_8126_() {
            if (HogbearEntity.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class HogbearFloatGoal
    extends FloatGoal {
        public HogbearFloatGoal() {
            super((Mob)HogbearEntity.this);
        }

        public void m_8056_() {
            super.m_8056_();
            HogbearEntity.this.clearStates();
        }

        public boolean m_8036_() {
            return HogbearEntity.this.m_20069_() && HogbearEntity.this.m_204036_(FluidTags.f_13131_) > 0.25 || HogbearEntity.this.m_20077_() || HogbearEntity.this.isInFluidType((fluidType, height) -> HogbearEntity.this.canSwimInFluidType((FluidType)fluidType) && height > 0.25);
        }
    }

    class SleepGoal
    extends HogbearBehaviorGoal {
        private static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.m_186073_((int)140);
        private int countdown;

        public SleepGoal() {
            this.countdown = HogbearEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (HogbearEntity.this.f_20900_ == 0.0f && HogbearEntity.this.f_20901_ == 0.0f && HogbearEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || HogbearEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return this.hasShelter() && !this.alertable() && !HogbearEntity.this.f_146808_;
        }

        public void m_8041_() {
            this.countdown = HogbearEntity.this.f_19796_.m_188503_(WAIT_TIME_BEFORE_SLEEP);
            HogbearEntity.this.clearStates();
        }

        public void m_8056_() {
            HogbearEntity.this.setSleeping(true);
            HogbearEntity.this.m_21573_().m_26573_();
            HogbearEntity.this.m_21566_().m_6849_(HogbearEntity.this.m_20185_(), HogbearEntity.this.m_20186_(), HogbearEntity.this.m_20189_(), 0.0);
        }
    }

    static class HogbearLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public HogbearLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            super(pMob, pLookAtType, pLookDistance);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    class SeekShelterGoal
    extends FleeSkyGoal {
        private int interval;

        public SeekShelterGoal(double pSpeedModifier) {
            super((PathfinderMob)HogbearEntity.this, pSpeedModifier);
            this.interval = SeekShelterGoal.m_186073_((int)100);
        }

        @Override
        public boolean m_8036_() {
            if (!HogbearEntity.this.m_5803_() && this.mob.m_5448_() == null) {
                if (HogbearEntity.this.m_9236_().m_45527_(this.mob.m_20183_())) {
                    return this.setWantedPos();
                }
                if (this.interval > 0) {
                    --this.interval;
                    return false;
                }
                this.interval = 100;
                BlockPos blockpos = this.mob.m_20183_();
                return HogbearEntity.this.m_9236_().m_45527_(blockpos) && this.setWantedPos();
            }
            return false;
        }

        @Override
        public void m_8056_() {
            HogbearEntity.this.clearStates();
            super.m_8056_();
        }
    }

    abstract class HogbearBehaviorGoal
    extends Goal {
        private final TargetingConditions alertableTargeting = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_().m_26888_((Predicate)new HogbearAlertableEntitiesSelector());

        HogbearBehaviorGoal() {
        }

        protected boolean hasShelter() {
            BlockPos blockpos = BlockPos.m_274561_((double)HogbearEntity.this.m_20185_(), (double)HogbearEntity.this.m_20191_().f_82292_, (double)HogbearEntity.this.m_20189_());
            return !HogbearEntity.this.m_9236_().m_45527_(blockpos) && HogbearEntity.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean alertable() {
            return !HogbearEntity.this.m_9236_().m_45971_(LivingEntity.class, this.alertableTargeting, (LivingEntity)HogbearEntity.this, HogbearEntity.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public static class HogbearAlertableEntitiesSelector
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity pEntity) {
            if (pEntity instanceof HogbearEntity) {
                return false;
            }
            if (!(pEntity instanceof Monster)) {
                if (!(pEntity instanceof Player) || !pEntity.m_5833_() && !((Player)pEntity).m_7500_()) {
                    return !pEntity.m_5803_();
                }
                return false;
            }
            return true;
        }
    }
}

