/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.custom.EmuEntity;
import net.dylanvhs.bountiful_critters.entity.custom.ToucanEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LionEntity
extends TamableAnimal
implements NeutralMob,
GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int timeUntilNextMane = this.f_19796_.m_188503_(8000) + 8000;
    private static final EntityDataAccessor<Boolean> IS_ARMORED = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ARMOR_SLIGHTLY_DAMAGED = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ARMOR_DAMAGED = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ARMOR_REPAIRED = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FUR_ID = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_MANE = SynchedEntityData.m_135353_(LionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean waxed = false;
    private static final Set<Item> TAME_FOOD = Sets.newHashSet((Object[])new Item[]{Items.f_42579_, Items.f_42580_, Items.f_42485_, Items.f_42486_, Items.f_42658_, Items.f_42659_, Items.f_42581_, Items.f_42582_, Items.f_42697_, Items.f_42698_, (Item)ModItems.RAW_SUNFISH_MEAT.get(), (Item)ModItems.COOKED_SUNFISH_MEAT.get(), (Item)ModItems.RAW_ANGELFISH.get(), (Item)ModItems.RAW_NEON_TETRA.get(), (Item)ModItems.RAW_BARRELEYE.get(), (Item)ModItems.RAW_KRILL.get(), (Item)ModItems.RAW_FLOUNDER.get(), (Item)ModItems.RAW_PILLBUG.get(), Items.f_42526_, Items.f_42530_, Items.f_42527_, Items.f_42531_});
    public static final Ingredient TAME_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42579_, Items.f_42580_, Items.f_42485_, Items.f_42486_, Items.f_42658_, Items.f_42659_, Items.f_42581_, Items.f_42582_, Items.f_42697_, Items.f_42698_, (ItemLike)ModItems.RAW_SUNFISH_MEAT.get(), (ItemLike)ModItems.COOKED_SUNFISH_MEAT.get(), (ItemLike)ModItems.RAW_ANGELFISH.get(), (ItemLike)ModItems.RAW_NEON_TETRA.get(), (ItemLike)ModItems.RAW_BARRELEYE.get(), (ItemLike)ModItems.RAW_KRILL.get(), (ItemLike)ModItems.RAW_FLOUNDER.get(), (ItemLike)ModItems.RAW_PILLBUG.get(), Items.f_42526_, Items.f_42530_, Items.f_42527_, Items.f_42531_});
    public int armorDurability = 256;

    public LionEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return LionEntity.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 0.25).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22285_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22265_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasMane", this.hasMane());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_HAS_MANE, (Object)compound.m_128471_("HasMane"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_ARMORED, (Object)false);
        this.f_19804_.m_135372_(IS_ARMOR_SLIGHTLY_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(IS_ARMOR_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(IS_ARMOR_REPAIRED, (Object)false);
        this.f_19804_.m_135372_(DATA_FUR_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_HAS_MANE, (Object)true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Sheep>((Mob)this, Sheep.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Cow>((Mob)this, Cow.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Pig>((Mob)this, Pig.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Chicken>((Mob)this, Chicken.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Rabbit>((Mob)this, Rabbit.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<EmuEntity>((Mob)this, EmuEntity.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<ToucanEntity>((Mob)this, ToucanEntity.class, true){

            public boolean m_8036_() {
                return !LionEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25){

            public boolean m_8036_() {
                return LionEntity.this.m_6162_() && super.m_8036_();
            }
        });
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.LION_SPAWN_EGG.get());
    }

    @Nullable
    public LionEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        LionEntity lion = (LionEntity)((EntityType)ModEntities.LION.get()).m_20615_((Level)pLevel);
        if (lion != null) {
            UUID uuid = this.m_21805_();
            if (uuid != null) {
                lion.m_21816_(uuid);
                lion.m_7105_(true);
            }
            int i = this.f_19796_.m_188499_() ? this.getVariant() : ((LionEntity)pOtherParent).getVariant();
            lion.setVariant(i);
            lion.m_21530_();
        }
        return lion;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isArmored()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)ModItems.LION_ARMOR.get());
            }
            this.setArmored(false);
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return TAME_ITEM.test(pStack);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.95f : 1.7f;
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_50546_);
    }

    public void m_7105_(boolean pTamed) {
        super.m_7105_(pTamed);
        if (pTamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
            this.m_21153_(50.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(8.0);
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int pRemainingPersistentAngerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            this.m_6858_(this.m_5912_());
            this.setArmorRepaired(this.isArmored() && this.armorDurability > 128);
            this.setArmorSlightlyDamaged(this.isArmored() && this.armorDurability < 128);
            this.setArmorDamaged(this.isArmored() && this.armorDurability < 64);
            if (this.isArmored() && this.armorDurability == 0) {
                this.setArmored(false);
                this.setArmorDamaged(false);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || this.hasMane() || !this.m_6084_() || this.m_6162_() || this.waxed || --this.timeUntilNextMane > 0)) {
            this.setMane(true);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (this.isArmored() && this.armorDurability > 0) {
            --this.armorDurability;
            --this.armorDurability;
            --this.armorDurability;
            --this.armorDurability;
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            pAmount = (pAmount + 1.0f) / 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.m_6162_()) {
            return false;
        }
        return prev;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return entityIn.m_7306_((Entity)this);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean hasMane() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_MANE);
    }

    public void setMane(boolean mane) {
        this.f_19804_.m_135381_(DATA_HAS_MANE, (Object)mane);
    }

    public boolean m_7757_(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast)) {
            if (pTarget instanceof LionEntity) {
                LionEntity wolf = (LionEntity)pTarget;
                return !wolf.m_21824_() || wolf.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() == Items.f_42574_) {
            if (!this.m_9236_().f_46443_ && this.readyForShearing()) {
                this.shear(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)pPlayer);
                this.setMane(false);
                this.timeUntilNextMane = this.f_19796_.m_188503_(8000) + 8000;
                itemstack.m_41622_(1, (LivingEntity)pPlayer, p_29822_ -> p_29822_.m_21190_(pHand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (itemstack.m_41720_() == Items.f_42784_ && !this.waxed && !this.hasMane()) {
            if (!this.m_9236_().f_46443_) {
                if (!pPlayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_144178_, 1.0f, 1.0f);
                this.waxed = true;
            }
            if (this.m_9236_().f_46443_ && !this.waxed) {
                Vec3 vec3 = this.m_20252_(0.0f);
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_41935_ && this.waxed) {
            if (!this.m_9236_().f_46443_) {
                if (!pPlayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_144060_, 1.0f, 1.0f);
                this.waxed = false;
            }
            if (this.m_9236_().f_46443_ && this.waxed) {
                Vec3 vec3 = this.m_20252_(0.0f);
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175829_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175829_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || TAME_FOOD.contains(itemstack.m_41720_()) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (itemstack.m_41720_() == ModItems.LION_ARMOR.get() && !this.isArmored() && !this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_5496_(SoundEvents.f_11973_, 1.0f, 1.0f);
                this.setArmored(true);
                this.setArmorRepaired(true);
                this.armorDurability = 256;
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_151052_ && this.isArmored() && this.armorDurability < 256 && !this.m_6162_()) {
                this.m_142075_(pPlayer, pHand, itemstack);
                this.m_5496_(SoundEvents.f_144119_, 1.0f, 1.0f);
                ++this.armorDurability;
                ++this.armorDurability;
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (TAME_FOOD.contains(itemstack.m_41720_()) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean isSheared() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FUR_ID) & 0x10) != 0;
    }

    public void setSheared(boolean pSheared) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FUR_ID);
        if (pSheared) {
            this.f_19804_.m_135381_(DATA_FUR_ID, (Object)((byte)(b0 | 0x10)));
        } else {
            this.f_19804_.m_135381_(DATA_FUR_ID, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public void shear(SoundSource pCategory) {
        this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12344_, pCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_19998_((ItemLike)Items.f_41935_);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public boolean readyForShearing() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_() && this.hasMane();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        float variantChange = this.m_217043_().m_188501_();
        if (variantChange <= 0.25f) {
            this.setVariant(0);
        } else if (variantChange <= 0.3f) {
            this.setVariant(1);
        } else if (variantChange <= 0.4f) {
            this.setVariant(0);
        } else if (variantChange <= 0.55f) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean isArmored() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMORED);
    }

    public void setArmored(boolean armored) {
        this.f_19804_.m_135381_(IS_ARMORED, (Object)armored);
    }

    public boolean isArmorRepaired() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMOR_REPAIRED);
    }

    public void setArmorRepaired(boolean armored) {
        this.f_19804_.m_135381_(IS_ARMOR_REPAIRED, (Object)armored);
    }

    public boolean isArmorSlightlyDamaged() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMOR_SLIGHTLY_DAMAGED);
    }

    public void setArmorSlightlyDamaged(boolean armored) {
        this.f_19804_.m_135381_(IS_ARMOR_SLIGHTLY_DAMAGED, (Object)armored);
    }

    public boolean isArmorDamaged() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMOR_DAMAGED);
    }

    public void setArmorDamaged(boolean armored) {
        this.f_19804_.m_135381_(IS_ARMOR_DAMAGED, (Object)armored);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 4, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (geoAnimatableAnimationState.isMoving() && !this.m_20142_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.lion.walk", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving() && this.m_20142_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.lion.sprint", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.lion.sit", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.lion.idle", Animation.LoopType.LOOP));
        geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.f_20911_ && geoAnimatableAnimationState.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            geoAnimatableAnimationState.getController().forceAnimationReset();
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.lion.attack", Animation.LoopType.PLAY_ONCE));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.5);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }
}

