/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.entity.ai.ModBlockPos;
import net.dylanvhs.bountiful_critters.entity.custom.StingrayEntity;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MarineIguanaEntity
extends Animal
implements GeoEntity,
Bucketable {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(MarineIguanaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(StingrayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SNEEZING = SynchedEntityData.m_135353_(MarineIguanaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_, Items.f_41867_});
    public int timeUntilNextSneeze = this.f_19796_.m_188503_(3500) + 3500;
    public boolean passive = false;

    public MarineIguanaEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new IguanaMoveControl(this);
        this.f_21365_ = new IguanaLookControl(this, 20);
        this.m_274367_(1.0f);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.MARINE_IGUANA_SPAWN_EGG.get());
    }

    public static String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "neon";
            case 2 -> "warm";
            case 3 -> "red";
            case 4 -> "ash";
            default -> "stony";
        };
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.25, TEMPTATION_ITEM, false));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10){

            public boolean m_8036_() {
                return MarineIguanaEntity.this.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 15){

            public boolean m_8036_() {
                return !MarineIguanaEntity.this.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new IguanaEatSeagrass(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean m_8036_() {
                return !MarineIguanaEntity.this.m_20069_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !MarineIguanaEntity.this.m_20069_() && super.m_8036_();
            }
        });
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22265_();
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_49994_) || blockstate.m_60713_(Blocks.f_50069_);
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(IS_SNEEZING, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.MARINE_IGUANA_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Age", this.m_146764_());
        compoundnbt.m_128405_("BucketVariantTag", this.getVariant());
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
        if (compound.m_128441_("Age")) {
            this.m_146762_(compound.m_128451_("Age"));
        }
        if (compound.m_128425_("BucketVariantTag", 3)) {
            this.setVariant(compound.m_128451_("BucketVariantTag"));
        }
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this);
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() == ModItems.SALTED_KELP.get() && !this.passive) {
            if (!this.m_9236_().f_46443_) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_6710_(null);
                this.m_5634_(20.0f);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.passive = true;
            }
            if (this.m_9236_().f_46443_ && !this.passive) {
                Vec3 vec3 = this.m_20252_(0.0f);
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123763_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123763_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public boolean isName() {
        String n = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return n != null && n.toLowerCase().contains("gojira");
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        boolean flag = false;
        float variantChange = this.m_217043_().m_188501_();
        if (reason != MobSpawnType.BUCKET && flag) {
            this.m_146762_(-24000);
        }
        if (variantChange <= 0.009f) {
            this.setVariant(1);
        } else if (variantChange <= 0.3f) {
            this.setVariant(2);
        } else if (variantChange <= 0.45f) {
            this.setVariant(3);
        } else if (variantChange <= 0.6f) {
            this.setVariant(4);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new AmphibiousPathNavigation((Mob)this, pLevel);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_144063_;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_144065_ : SoundEvents.f_144064_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_144066_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_27487_() && !this.m_8077_();
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        MarineIguanaEntity iguana = (MarineIguanaEntity)((EntityType)ModEntities.MARINE_IGUANA.get()).m_20615_((Level)pLevel);
        if (iguana != null) {
            int i = this.f_19796_.m_188499_() ? this.getVariant() : ((MarineIguanaEntity)pOtherParent).getVariant();
            iguana.setVariant(i);
            iguana.m_21530_();
        }
        return iguana;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isSneezing();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && this.m_20096_() && --this.timeUntilNextSneeze <= 0) {
            this.m_5496_(SoundEvents.f_144063_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_20000_((ItemLike)ModItems.SALT.get(), 2);
            this.timeUntilNextSneeze = this.f_19796_.m_188503_(3500) + 3500;
            this.setSneezing(true);
            double d0 = 0.0;
            double d1 = Math.max(0.0, 1.0 - d0);
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.4f * d1, 0.0));
        } else if (this.timeUntilNextSneeze > 0) {
            this.setSneezing(false);
        }
        if (this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && this.m_20096_() && this.timeUntilNextSneeze < 3) {
            for (int i = 0; i < 8; ++i) {
                Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123764_, this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(this.m_6107_() ? 0.0 : 0.2);
        }
    }

    public boolean isSneezing() {
        return (Boolean)this.f_19804_.m_135370_(IS_SNEEZING);
    }

    public void setSneezing(boolean sneezing) {
        this.f_19804_.m_135381_(IS_SNEEZING, (Object)sneezing);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20069_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.marine_iguana.walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isSneezing()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.marine_iguana.sneeze", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.m_20069_() && !this.m_20096_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.marine_iguana.swim", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.marine_iguana.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    static class IguanaMoveControl
    extends SmoothSwimmingMoveControl {
        private final MarineIguanaEntity axolotl;

        public IguanaMoveControl(MarineIguanaEntity pAxolotl) {
            super((Mob)pAxolotl, 85, 10, 0.6f, 0.6f, true);
            this.axolotl = pAxolotl;
        }

        public void m_8126_() {
            super.m_8126_();
        }
    }

    class IguanaLookControl
    extends SmoothSwimmingLookControl {
        public IguanaLookControl(MarineIguanaEntity pAxolotl, int pMaxYRotFromCenter) {
            super((Mob)pAxolotl, pMaxYRotFromCenter);
        }

        public void m_8128_() {
            super.m_8128_();
        }
    }

    public class IguanaEatSeagrass
    extends Goal {
        private final MarineIguanaEntity iguana;
        private int idleAtFlowerTime = 0;
        private int timeoutCounter = 0;
        private int searchCooldown = 0;
        private boolean isAboveDestinationBear;
        private BlockPos destinationBlock;
        private final BlockSorter targetSorter;

        public IguanaEatSeagrass(MarineIguanaEntity iguana) {
            this.iguana = iguana;
            this.targetSorter = new BlockSorter((Entity)iguana);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void m_8056_() {
            super.m_8056_();
        }

        public boolean m_8036_() {
            if (!this.iguana.m_6162_() && this.iguana.m_20069_() && !this.iguana.passive) {
                if (this.searchCooldown <= 0) {
                    this.resetTarget();
                    this.searchCooldown = 1000 + this.iguana.m_217043_().m_188503_(1000);
                    return this.destinationBlock != null;
                }
                --this.searchCooldown;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.destinationBlock != null && this.timeoutCounter < 1200 && (this.iguana.m_5448_() == null || !this.iguana.m_5448_().m_6084_());
        }

        public void m_8041_() {
            this.searchCooldown = 1000;
            this.timeoutCounter = 0;
            this.destinationBlock = null;
        }

        public double getTargetDistanceSq() {
            return 2.3;
        }

        public void m_8037_() {
            BlockPos blockpos = this.destinationBlock;
            float yDist = (float)Math.abs((double)blockpos.m_123342_() - this.iguana.m_20186_() - (double)(this.iguana.m_20206_() / 2.0f));
            this.iguana.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 1.0);
            if (!this.isWithinXZDist(blockpos, this.iguana.m_20182_(), this.getTargetDistanceSq()) || yDist > 2.0f) {
                this.isAboveDestinationBear = false;
                ++this.timeoutCounter;
            } else {
                this.isAboveDestinationBear = true;
                --this.timeoutCounter;
            }
            if (this.timeoutCounter > 2400) {
                this.m_8041_();
            }
            if (this.getIsAboveDestination()) {
                this.iguana.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.destinationBlock.m_123341_() + 0.5, (double)this.destinationBlock.m_123342_(), (double)this.destinationBlock.m_123343_() + 0.5));
                if (this.idleAtFlowerTime >= 2) {
                    this.idleAtFlowerTime = 0;
                    this.breakBlock();
                    MarineIguanaEntity.this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    this.m_8041_();
                } else {
                    ++this.idleAtFlowerTime;
                }
            }
            super.m_8037_();
        }

        private void resetTarget() {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            int radius = 16;
            for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.iguana.m_20183_().m_7918_(-radius, -radius, -radius), (BlockPos)this.iguana.m_20183_().m_7918_(radius, radius, radius)).map(BlockPos::m_7949_).collect(Collectors.toList())) {
                if (this.iguana.m_9236_().m_46859_(pos) || !this.shouldMoveTo((LevelReader)this.iguana.m_9236_(), pos) || this.iguana.m_20069_() && !this.isBlockTouchingWater(pos)) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.targetSorter);
                for (BlockPos pos : allBlocks) {
                    if (!this.hasLineOfSightBlock(pos)) continue;
                    this.destinationBlock = pos;
                    return;
                }
            }
            this.destinationBlock = null;
        }

        private boolean isBlockTouchingWater(BlockPos pos) {
            for (Direction dir : Direction.values()) {
                if (!this.iguana.m_9236_().m_6425_(pos.m_121945_(dir)).m_205070_(FluidTags.f_13131_)) continue;
                return true;
            }
            return false;
        }

        private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
            return blockpos.m_123331_((Vec3i)ModBlockPos.fromCoords(positionVec.m_7096_(), blockpos.m_123342_(), positionVec.m_7094_())) < distance * distance;
        }

        protected boolean getIsAboveDestination() {
            return this.isAboveDestinationBear;
        }

        private void breakBlock() {
            if (this.shouldMoveTo((LevelReader)this.iguana.m_9236_(), this.destinationBlock)) {
                BlockState state = this.iguana.m_9236_().m_8055_(this.destinationBlock);
                if (!this.iguana.m_9236_().m_46859_(this.destinationBlock) && ForgeHooks.canEntityDestroy((Level)this.iguana.m_9236_(), (BlockPos)this.destinationBlock, (LivingEntity)this.iguana) && state.m_60800_((BlockGetter)this.iguana.m_9236_(), this.destinationBlock) >= 0.0f) {
                    MarineIguanaEntity.this.m_9236_().m_46961_(this.destinationBlock, false);
                    MarineIguanaEntity.this.m_5496_(SoundEvents.f_12543_, 1.0f, 1.0f);
                    MarineIguanaEntity.this.m_19998_((ItemLike)ModItems.SEAGRASS_BALL.get());
                }
            }
        }

        private boolean hasLineOfSightBlock(BlockPos destinationBlock) {
            Vec3 Vector3d = new Vec3(this.iguana.m_20185_(), this.iguana.m_20188_(), this.iguana.m_20189_());
            Vec3 blockVec = Vec3.m_82512_((Vec3i)destinationBlock);
            BlockHitResult result = this.iguana.m_9236_().m_45547_(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.iguana));
            return result.m_82425_().equals((Object)destinationBlock);
        }

        protected boolean shouldMoveTo(LevelReader worldIn, BlockPos pos) {
            Item blockItem = worldIn.m_8055_(pos).m_60734_().m_5456_();
            return worldIn.m_8055_(pos).m_60713_(Blocks.f_50037_) || worldIn.m_8055_(pos).m_60713_(Blocks.f_50038_);
        }

        public record BlockSorter(Entity entity) implements Comparator<BlockPos>
        {
            @Override
            public int compare(BlockPos pos1, BlockPos pos2) {
                double distance1 = this.getDistance(pos1);
                double distance2 = this.getDistance(pos2);
                return Double.compare(distance1, distance2);
            }

            private double getDistance(BlockPos pos) {
                double deltaX = this.entity.m_20185_() - ((double)pos.m_123341_() + 0.5);
                double deltaY = this.entity.m_20186_() + (double)this.entity.m_20192_() - ((double)pos.m_123342_() + 0.5);
                double deltaZ = this.entity.m_20189_() - ((double)pos.m_123343_() + 0.5);
                return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
            }
        }
    }
}

