/*
 * Decompiled with CFR 0.152.
 */
package net.dylanvhs.bountiful_critters.entity.custom;

import javax.annotation.Nullable;
import net.dylanvhs.bountiful_critters.entity.ModEntities;
import net.dylanvhs.bountiful_critters.item.ModItems;
import net.dylanvhs.bountiful_critters.sounds.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PheasantEntity
extends Animal
implements GeoAnimatable {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private float nextFlap = 1.0f;
    public int timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_});
    private PanicGoal panicGoal;

    public PheasantEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22265_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.PHEASANT_SPAWN_EGG.get());
    }

    @Nullable
    public PheasantEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (PheasantEntity)((EntityType)ModEntities.PHEASANT.get()).m_20615_((Level)pLevel);
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.m_20096_() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.95f : 1.2f;
    }

    public static <T extends Mob> boolean canSpawn(EntityType type, LevelAccessor worldIn, MobSpawnType reason, BlockPos p_223317_3_, RandomSource random) {
        BlockState blockstate = worldIn.m_8055_(p_223317_3_.m_7495_());
        return blockstate.m_60713_(Blocks.f_50440_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.PHEASANT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.PHEASANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11751_;
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.5f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.panicGoal = new PanicGoal((PathfinderMob)this, 1.3);
        this.f_21345_.m_25352_(0, (Goal)this.panicGoal);
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, TEMPTATION_ITEM, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.3, 1.3));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.timeUntilNextEgg <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)ModItems.PHEASANT_EGG.get());
            this.timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
        }
        this.m_6858_(this.isPanicking());
    }

    private boolean isPanicking() {
        return this.panicGoal != null && this.panicGoal.m_25703_();
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public boolean m_6573_(Player pPlayer) {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<GeoAnimatable> geoAnimatableAnimationState) {
        if (!this.m_20096_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pheasant.fall", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(2.5);
            return PlayState.CONTINUE;
        }
        if (geoAnimatableAnimationState.isMoving() && !this.m_20142_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pheasant.walk", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(1.25);
            return PlayState.CONTINUE;
        }
        if (this.m_20142_()) {
            geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pheasant.walk", Animation.LoopType.LOOP));
            geoAnimatableAnimationState.getController().setAnimationSpeed(5.0);
            return PlayState.CONTINUE;
        }
        geoAnimatableAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.pheasant.idle", Animation.LoopType.LOOP));
        geoAnimatableAnimationState.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }
}

