/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class ItemBuilder
extends Item {
    public static final String NBTBLOCKSTATE = "blockstate";

    public ItemBuilder(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static void setBlockState(ItemStack wand, BlockState target) {
        CompoundTag encoded = NbtUtils.m_129202_((BlockState)target);
        wand.m_41784_().m_128365_(NBTBLOCKSTATE, (Tag)encoded);
    }

    public static BlockState getBlockState(Level level, ItemStack wand) {
        if (!wand.m_41784_().m_128441_(NBTBLOCKSTATE)) {
            return null;
        }
        return NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)wand.m_41784_().m_128469_(NBTBLOCKSTATE));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockPos buildAt = pos.m_121945_(context.m_43719_());
        if (world.m_7702_(pos) instanceof TileMain) {
            ItemStack stack = player.m_21120_(hand);
            CompoundTag tag = stack.m_41784_();
            DimPos.putPos(stack, pos, world);
            stack.m_41751_(tag);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return InteractionResult.SUCCESS;
        }
        if (world.m_46859_(buildAt) || world.m_8055_(buildAt).m_60767_().m_76332_()) {
            player.m_6674_(hand);
            ItemStack stack = player.m_21120_(hand);
            DimPos dp = DimPos.getPosStored(stack);
            if (dp != null && hand == InteractionHand.MAIN_HAND && !world.f_46443_) {
                ServerLevel serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.m_7654_());
                if (serverTargetWorld == null) {
                    StorageNetworkMod.LOGGER.error("Missing dimension key " + dp.getDimension());
                    return InteractionResult.PASS;
                }
                BlockEntity tile = serverTargetWorld.m_7702_(dp.getBlockPos());
                BlockState targetState = ItemBuilder.getBlockState(world, stack);
                if (tile instanceof TileMain && targetState != null) {
                    TileMain network = (TileMain)tile;
                    ItemStackMatcher matcher = new ItemStackMatcher(new ItemStack((ItemLike)targetState.m_60734_()), false, false);
                    ItemStack found = network.request(matcher, 1, true);
                    if (!found.m_41619_()) {
                        boolean success = this.placeStateSafe(world, player, buildAt, targetState);
                        if (success) {
                            network.request(matcher, 1, false);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"item.remote.notfound.item"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"item.remote.notfound"), true);
                }
            }
        }
        return InteractionResult.PASS;
    }

    private boolean placeStateSafe(Level world, Player player, BlockPos placePos, BlockState placeState) {
        BlockState stateHere = world.m_8055_(placePos);
        if (stateHere.m_60734_() == Blocks.f_50016_ || stateHere.m_60767_().m_76332_()) {
            return world.m_7731_(placePos, placeState, 3);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        MutableComponent t = Component.m_237115_((String)(this.m_5524_() + ".tooltip"));
        t.m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)t);
        if (stack.m_41782_()) {
            BlockState target;
            DimPos dp = DimPos.getPosStored(stack);
            if (dp != null) {
                tooltip.add(dp.makeTooltip());
            }
            if ((target = ItemBuilder.getBlockState(worldIn, stack)) != null) {
                String block = target.m_60734_().m_7705_();
                t = Component.m_237115_((String)block);
                t.m_130940_(ChatFormatting.AQUA);
                tooltip.add((Component)t);
            } else {
                t = Component.m_237115_((String)(this.m_5524_() + ".blockstate"));
                t.m_130940_(ChatFormatting.AQUA);
                tooltip.add((Component)t);
            }
        }
    }

    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack held = player.m_21120_(event.getHand());
        if (held.m_41720_() == SsnRegistry.Items.BUILDER_REMOTE.get()) {
            Level world = player.m_20193_();
            BlockState target = world.m_8055_(event.getPos());
            ItemBuilder.setBlockState(held, target);
            UtilTileEntity.statusMessage(player, target);
            event.setResult(Event.Result.DENY);
        }
    }
}

