/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.api;

import com.google.common.base.Objects;
import com.lothrazar.storagenetwork.StorageNetwork;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public class DimPos
implements INBTSerializable<CompoundTag> {
    private String dimension;
    private BlockPos pos = new BlockPos(0, 0, 0);
    private Level world;
    public static final String NBT_Z = "Z";
    public static final String NBT_Y = "Y";
    public static final String NBT_X = "X";
    public static final String NBT_DIM = "dimension";
    public static final String NBT_BOUND = "bound";

    public DimPos(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public DimPos(Level world, BlockPos pos) {
        this.pos = pos;
        this.setWorld(world);
        if (world != null) {
            this.dimension = DimPos.dimensionToString(world);
        }
    }

    public static DimPos getPosStored(ItemStack itemStackIn) {
        if (itemStackIn.m_41783_() == null || !itemStackIn.m_41784_().m_128471_(NBT_BOUND)) {
            return null;
        }
        return new DimPos(itemStackIn.m_41784_());
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public BlockState getBlockState() {
        return this.getWorld().m_8055_(this.getBlockPos());
    }

    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface) {
        return this.getTileEntity(tileEntityClassOrInterface, this.getWorld());
    }

    public static String dimensionToString(Level w) {
        return w.m_46472_().m_135782_().toString();
    }

    public static void putPos(ItemStack stack, BlockPos pos, Level world) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(NBT_X, pos.m_123341_());
        tag.m_128405_(NBT_Y, pos.m_123342_());
        tag.m_128405_(NBT_Z, pos.m_123343_());
        tag.m_128359_(NBT_DIM, DimPos.dimensionToString(world));
        tag.m_128379_(NBT_BOUND, true);
    }

    public static String getDim(ItemStack stack) {
        return stack.m_41784_().m_128461_(NBT_DIM);
    }

    public static void putDim(ItemStack stack, Level world) {
        stack.m_41784_().m_128359_(NBT_DIM, DimPos.dimensionToString(world));
    }

    public static ServerLevel stringDimensionLookup(String s, MinecraftServer serv) {
        return DimPos.stringDimensionLookup(ResourceLocation.m_135820_((String)s), serv);
    }

    public static ServerLevel stringDimensionLookup(ResourceLocation s, MinecraftServer serv) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)s);
        if (worldKey == null) {
            return null;
        }
        return serv.m_129880_(worldKey);
    }

    @Nullable
    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface, Level world) {
        BlockEntity tileEntity;
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        if (this.dimension != null && world.m_142572_() != null && !this.dimension.isEmpty()) {
            ServerLevel dimWorld = DimPos.stringDimensionLookup(this.dimension, world.m_142572_());
            if (dimWorld != null) {
                world = dimWorld.m_6018_();
            } else {
                StorageNetwork.LOGGER.error(" Dimworld NOT FOUND for " + this.dimension);
            }
        }
        if ((tileEntity = world.m_7702_(this.getBlockPos())) == null) {
            return null;
        }
        if (!tileEntityClassOrInterface.isAssignableFrom(tileEntity.getClass())) {
            return null;
        }
        return (V)tileEntity;
    }

    public <V> V getCapability(Capability<V> capability, Direction side) {
        Level world = this.getWorld();
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        BlockEntity tileEntity = world.m_7702_(this.getBlockPos());
        if (tileEntity == null) {
            return null;
        }
        return (V)tileEntity.getCapability(capability, side).orElse(null);
    }

    public boolean isLoaded() {
        if (this.getWorld() == null) {
            return false;
        }
        return this.getWorld().m_46805_(this.pos);
    }

    public boolean equals(Level world, BlockPos pos) {
        return pos.equals((Object)this.pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimPos dimPos = (DimPos)o;
        return this.dimension.equals(dimPos.dimension) && Objects.equal((Object)this.pos, (Object)dimPos.pos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimension, this.pos});
    }

    public String toString() {
        return "[dimension=" + this.dimension + ", pos=" + this.pos + ", world=" + this.getWorld() + "]";
    }

    public CompoundTag serializeNBT() {
        if (this.pos == null) {
            this.pos = new BlockPos(0, 0, 0);
        }
        CompoundTag result = NbtUtils.m_129224_((BlockPos)this.pos);
        result.m_128359_(NBT_DIM, this.dimension);
        return result;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.pos = NbtUtils.m_129239_((CompoundTag)nbt);
        this.dimension = nbt.m_128461_(NBT_DIM);
    }

    public DimPos offset(Direction direction) {
        if (this.pos == null || direction == null) {
            StorageNetwork.LOGGER.info("Error: null offset in DimPos " + direction);
            return null;
        }
        return new DimPos(this.getWorld(), this.pos.m_142300_(direction));
    }

    public ChunkAccess getChunk() {
        return this.getWorld().m_46865_(this.pos);
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Component makeTooltip() {
        if (this.pos == null) {
            return null;
        }
        return new TranslatableComponent("[" + this.pos.m_123341_() + ", " + this.pos.m_123342_() + ", " + this.pos.m_123343_() + ", " + this.dimension + "]").m_130940_(ChatFormatting.DARK_GRAY);
    }
}

