/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.input;

import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.block.TileCableWithFacing;
import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.cable.EnumConnectType;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileCableIO
extends TileCableWithFacing {
    protected CapabilityConnectableAutoIO ioStorage = new CapabilityConnectableAutoIO(this, EnumStorageDirection.IN);

    public TileCableIO(BlockPos pos, BlockState state) {
        super(SsnRegistry.IMPORTKABELTILE, pos, state);
    }

    @Override
    public void setDirection(Direction direction) {
        super.setDirection(direction);
        this.ioStorage.setInventoryFace(direction);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.ioStorage.deserializeNBT(compound.m_128469_("ioStorage"));
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("ioStorage", (Tag)this.ioStorage.serializeNBT());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_AUTO_IO) {
            LazyOptional cap = LazyOptional.of(() -> this.ioStorage);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    private void tick() {
        if (this.getDirection() == null) {
            this.findNewDirection();
            if (this.getDirection() != null) {
                BlockState newState = BlockCable.cleanBlockState(this.m_58900_());
                newState = (BlockState)newState.m_61124_((Property)BlockCable.FACING_TO_PROPERTY_MAP.get(this.getDirection()), (Comparable)((Object)EnumConnectType.CABLE));
                this.f_58857_.m_46597_(this.f_58858_, newState);
            }
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCableIO tile) {
        tile.tick();
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCableIO tile) {
        tile.tick();
    }
}

