/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.block.BaseBlock;
import com.lothrazar.storagenetwork.block.cable.EnumConnectType;
import com.lothrazar.storagenetwork.block.cable.ShapeCache;
import com.lothrazar.storagenetwork.block.cable.TileCable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableAutoIO;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockCable
extends BaseBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final EnumProperty<EnumConnectType> DOWN = EnumProperty.m_61587_((String)"down", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> UP = EnumProperty.m_61587_((String)"up", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> NORTH = EnumProperty.m_61587_((String)"north", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> SOUTH = EnumProperty.m_61587_((String)"south", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> WEST = EnumProperty.m_61587_((String)"west", EnumConnectType.class);
    private static final EnumProperty<EnumConnectType> EAST = EnumProperty.m_61587_((String)"east", EnumConnectType.class);
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, NORTH);
        p.put(Direction.EAST, EAST);
        p.put(Direction.SOUTH, SOUTH);
        p.put(Direction.WEST, WEST);
        p.put(Direction.UP, UP);
        p.put(Direction.DOWN, DOWN);
    });
    private static final double top = 16.0;
    private static final double bot = 0.0;
    private static final double C = 8.0;
    private static final double w = 2.0;
    private static final double sm = 6.0;
    private static final double lg = 10.0;
    private static final VoxelShape AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_UP = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape AABB_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape AABB_EAST = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public BlockCable(String registryName) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.2f), registryName);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(EAST, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(SOUTH, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(WEST, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(UP, (Comparable)((Object)EnumConnectType.NONE))).m_61124_(DOWN, (Comparable)((Object)EnumConnectType.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Deprecated
    public boolean m_7357_(BlockState bs, BlockGetter bg, BlockPos pos, PathComputationType path) {
        return false;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity != null) {
                IConnectableItemAutoIO connectable;
                IItemHandler items = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                if (items != null) {
                    for (int i = 0; i < items.getSlots(); ++i) {
                        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)items.getStackInSlot(i));
                    }
                    worldIn.m_46717_(pos, (Block)this);
                }
                if ((connectable = (IConnectableItemAutoIO)tileentity.getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO).orElse(null)) instanceof CapabilityConnectableAutoIO) {
                    CapabilityConnectableAutoIO filterCable = (CapabilityConnectableAutoIO)connectable;
                    for (int i = 0; i < filterCable.upgrades.getSlots(); ++i) {
                        Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)filterCable.upgrades.getStackInSlot(i));
                    }
                    worldIn.m_46717_(pos, (Block)this);
                }
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public static BlockState cleanBlockState(BlockState state) {
        for (Direction d : Direction.values()) {
            EnumProperty<EnumConnectType> prop = FACING_TO_PROPERTY_MAP.get(d);
            if (state.m_61143_(prop) != EnumConnectType.INVENTORY) continue;
            state = (BlockState)state.m_61124_(prop, (Comparable)((Object)EnumConnectType.NONE));
        }
        return state;
    }

    private boolean shapeConnects(BlockState state, EnumProperty<EnumConnectType> dirctionProperty) {
        return ((EnumConnectType)((Object)state.m_61143_(dirctionProperty))).equals((Object)EnumConnectType.CABLE) || ((EnumConnectType)((Object)state.m_61143_(dirctionProperty))).equals((Object)EnumConnectType.INVENTORY);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ShapeCache.getOrCreate(state, this::createShape);
    }

    private VoxelShape createShape(BlockState state) {
        VoxelShape shape = AABB;
        if (this.shapeConnects(state, UP)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_UP, (BooleanOp)BooleanOp.f_82695_);
        }
        if (this.shapeConnects(state, DOWN)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_DOWN, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((EnumConnectType)((Object)state.m_61143_(WEST))).equals((Object)EnumConnectType.CABLE)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_WEST, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((EnumConnectType)((Object)state.m_61143_(EAST))).equals((Object)EnumConnectType.CABLE)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_EAST, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((EnumConnectType)((Object)state.m_61143_(NORTH))).equals((Object)EnumConnectType.CABLE)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_NORTH, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((EnumConnectType)((Object)state.m_61143_(SOUTH))).equals((Object)EnumConnectType.CABLE)) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)AABB_SOUTH, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public RenderShape m_7514_(BlockState bs) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCable(pos, state);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState stateIn, LivingEntity placer, ItemStack stack) {
        for (Direction d : Direction.values()) {
            BlockPos posoff = pos.m_142300_(d);
            BlockState facingState = worldIn.m_8055_(posoff);
            BlockEntity tileOffset = worldIn.m_7702_(posoff);
            IConnectable cap = null;
            if (tileOffset != null) {
                cap = (IConnectable)tileOffset.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY).orElse(null);
            }
            if (cap == null && facingState.m_60734_() != SsnRegistry.MAIN) continue;
            stateIn = (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.CABLE));
            worldIn.m_46597_(pos, stateIn);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(facing);
        if (facingState.m_60734_() == SsnRegistry.MAIN || facingState.m_60734_() instanceof BlockCable) {
            return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        BlockEntity tileOffset = world.m_7702_(facingPos);
        IConnectable cap = null;
        if (tileOffset != null) {
            cap = (IConnectable)tileOffset.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY).orElse(null);
        }
        if (cap != null) {
            if (cap.getMainPos() != null) {
                return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.INVENTORY));
            }
            return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.CABLE));
        }
        if (!this.hasInventoryAlready(stateIn) && BlockCable.isInventory(stateIn, facing, facingState, world, currentPos, facingPos)) {
            return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        return (BlockState)stateIn.m_61124_(property, (Comparable)((Object)EnumConnectType.NONE));
    }

    private boolean hasInventoryAlready(BlockState stateIn) {
        for (Direction d : Direction.values()) {
            if (!((EnumConnectType)((Object)stateIn.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(d)))).isInventory()) continue;
            return true;
        }
        return false;
    }

    private static boolean isInventory(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == null) {
            return false;
        }
        if (!TileMain.isTargetAllowed(facingState)) {
            return false;
        }
        BlockEntity neighbor = world.m_7702_(facingPos);
        return neighbor != null && neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_()).orElse(null) != null;
    }
}

