/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.main;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumStorageDirection;
import com.lothrazar.storagenetwork.api.IConnectable;
import com.lothrazar.storagenetwork.api.IConnectableItemAutoIO;
import com.lothrazar.storagenetwork.api.IConnectableLink;
import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import com.lothrazar.storagenetwork.block.exchange.TileExchange;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.UtilInventory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMain
extends BlockEntity {
    private Set<DimPos> connectables;
    private Map<String, DimPos> importCache = new HashMap<String, DimPos>();
    private boolean shouldRefresh = true;

    private DimPos getDimPos() {
        return new DimPos(this.f_58857_, this.f_58858_);
    }

    public TileMain(BlockPos pos, BlockState state) {
        super(SsnRegistry.MAINTILEENTITY, pos, state);
    }

    public List<ItemStack> getSortedStacks() {
        ArrayList stacks = Lists.newArrayList();
        try {
            if (this.getConnectablePositions() == null) {
                this.refreshNetwork();
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        try {
            for (IConnectableLink storage : this.getSortedConnectableStorage()) {
                for (ItemStack stack : storage.getStoredStacks(true)) {
                    if (stack == null || stack.m_41619_()) continue;
                    TileMain.addOrMergeIntoList(stacks, stack);
                }
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        return stacks;
    }

    public List<ItemStack> getStacks() {
        ArrayList stacks = Lists.newArrayList();
        try {
            if (this.getConnectablePositions() == null) {
                this.refreshNetwork();
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        try {
            for (IConnectableLink storage : this.getConnectableStorage()) {
                for (ItemStack stack : storage.getStoredStacks(true)) {
                    if (stack == null || stack.m_41619_()) continue;
                    TileMain.addOrMergeIntoList(stacks, stack);
                }
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.info("3rd party storage mod has an error", (Throwable)e);
        }
        return stacks;
    }

    private static void addOrMergeIntoList(List<ItemStack> list, ItemStack stackToAdd) {
        boolean added = false;
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackToAdd, (ItemStack)stack)) continue;
            stack.m_41764_(stack.m_41613_() + stackToAdd.m_41613_());
            added = true;
            break;
        }
        if (!added) {
            list.add(stackToAdd);
        }
    }

    int emptySlots() {
        int countEmpty = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            countEmpty += storage.getEmptySlots();
        }
        return countEmpty;
    }

    public int getAmount(ItemStackMatcher fil) {
        if (fil == null) {
            return 0;
        }
        int totalCount = 0;
        for (ItemStack stack : this.getStacks()) {
            if (!fil.match(stack)) continue;
            totalCount += stack.m_41613_();
        }
        return totalCount;
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    private Set<DimPos> getConnectables(DimPos sourcePos) {
        HashSet<DimPos> result = new HashSet<DimPos>();
        this.addConnectables(sourcePos, result);
        return result;
    }

    private void addConnectables(DimPos sourcePos, Set<DimPos> set) {
        if (sourcePos == null || sourcePos.getWorld() == null || !sourcePos.isLoaded()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IConnectable capabilityConnectable;
            ChunkAccess chunk;
            DimPos lookPos = sourcePos.offset(direction);
            if (!lookPos.isLoaded() || (chunk = lookPos.getChunk()) == null) continue;
            TileMain maybeMain = lookPos.getTileEntity(TileMain.class);
            if (maybeMain != null && !lookPos.equals(this.f_58857_, this.f_58858_)) {
                TileMain.nukeAndDrop(lookPos);
                continue;
            }
            BlockEntity tileHere = lookPos.getTileEntity(BlockEntity.class);
            if (tileHere == null || (capabilityConnectable = (IConnectable)tileHere.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, direction.m_122424_()).orElse(null)) == null) continue;
            if (capabilityConnectable.getPos() == null) {
                capabilityConnectable.setPos(lookPos);
                capabilityConnectable.setMainPos(this.getDimPos());
            }
            if (capabilityConnectable == null) continue;
            capabilityConnectable.setMainPos(this.getDimPos());
            DimPos realConnectablePos = capabilityConnectable.getPos();
            boolean beenHereBefore = set.contains(realConnectablePos);
            if (beenHereBefore) continue;
            if (realConnectablePos.getWorld() == null) {
                realConnectablePos.setWorld(sourcePos.getWorld());
            }
            set.add(realConnectablePos);
            this.addConnectables(realConnectablePos, set);
            tileHere.m_6596_();
            chunk.m_8092_(true);
        }
    }

    private static void nukeAndDrop(DimPos lookPos) {
        lookPos.getWorld().m_46961_(lookPos.getBlockPos(), true);
        lookPos.getWorld().m_46747_(lookPos.getBlockPos());
    }

    public static boolean isTargetAllowed(BlockState state) {
        if (state.m_60734_() == Blocks.f_50016_) {
            return false;
        }
        String blockId = state.m_60734_().getRegistryName().toString();
        for (String s : StorageNetwork.CONFIG.ignorelist()) {
            if (!blockId.equals(s)) continue;
            return false;
        }
        return true;
    }

    public void refreshNetwork() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.shouldRefresh = true;
    }

    private boolean hasCachedSlot(ItemStack stack) {
        return this.importCache.containsKey(TileMain.getStackKey(stack));
    }

    private DimPos getCachedSlot(ItemStack stack) {
        return this.importCache.get(TileMain.getStackKey(stack));
    }

    public int insertStack(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return 0;
        }
        String key = TileMain.getStackKey(stack);
        if (this.hasCachedSlot(stack)) {
            DimPos cachedStoragePos = this.getCachedSlot(stack);
            IConnectableLink storage = cachedStoragePos.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null);
            if (storage == null) {
                this.importCache.remove(key);
            } else {
                boolean canStillImport = storage.getSupportedTransferDirection().match(EnumStorageDirection.IN);
                if (canStillImport && storage.insertStack(stack, true).m_41613_() < stack.m_41613_()) {
                    stack = storage.insertStack(stack, simulate);
                } else {
                    this.importCache.remove(key);
                }
            }
        }
        if (stack.m_41619_()) {
            return 0;
        }
        List<IConnectableLink> storages = this.getSortedConnectableStorage();
        for (IConnectableLink storage : storages) {
            try {
                if (!storage.getSupportedTransferDirection().match(EnumStorageDirection.IN) || storage.insertStack(stack, true).m_41613_() >= stack.m_41613_()) continue;
                stack = storage.insertStack(stack, simulate);
            }
            catch (Exception e) {
                StorageNetwork.LOGGER.error("insertStack container issue", (Throwable)e);
            }
        }
        return stack.m_41613_();
    }

    private static String getStackKey(ItemStack stackInCopy) {
        return stackInCopy.m_41720_().getRegistryName().toString();
    }

    private void updateImports() {
        for (IConnectable connectable : this.getConnectables()) {
            boolean power;
            ItemStack stack;
            IConnectableItemAutoIO storage;
            if (connectable == null || connectable.getPos() == null || (storage = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null)) == null || storage.ioDirection() != EnumStorageDirection.IN || !storage.runNow(connectable.getPos(), this) || (stack = storage.extractNextStack(storage.getTransferRate(), true)).m_41619_() || storage.needsRedstone() && !(power = this.f_58857_.m_46753_(connectable.getPos().getBlockPos()))) continue;
            int countUnmoved = this.insertStack(stack, true);
            int countMoved = stack.m_41613_() - countUnmoved;
            if (countMoved <= 0) continue;
            ItemStack actuallyExtracted = storage.extractNextStack(countMoved, false);
            connectable.getPos().getWorld().m_46745_(connectable.getPos().getBlockPos()).m_6427_();
            this.insertStack(actuallyExtracted, false);
        }
    }

    private void updateProcess() {
    }

    private void updateExports() {
        block2: for (IConnectable connectable : this.getConnectables()) {
            boolean power;
            IConnectableItemAutoIO storage;
            if (connectable == null || connectable.getPos() == null || (storage = connectable.getPos().getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null)) == null || storage.ioDirection() != EnumStorageDirection.OUT || !storage.runNow(connectable.getPos(), this) || storage.needsRedstone() && !(power = this.f_58857_.m_46753_(connectable.getPos().getBlockPos()))) continue;
            for (IItemStackMatcher matcher : storage.getAutoExportList()) {
                ItemStack realExtractedStack;
                ItemStack requestedStack;
                boolean stockMode = storage.isStockMode();
                int amtToRequest = storage.getTransferRate();
                if (stockMode) {
                    try {
                        BlockEntity tileEntity = this.f_58857_.m_7702_(connectable.getPos().getBlockPos().m_142300_(storage.facingInventory()));
                        IItemHandler targetInventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).orElse(null);
                        int stillNeeds = UtilInventory.containsAtLeastHowManyNeeded(targetInventory, matcher.getStack(), matcher.getStack().m_41613_());
                        if (stillNeeds == 0) continue;
                        amtToRequest = Math.min(stillNeeds, amtToRequest);
                    }
                    catch (Throwable e) {
                        StorageNetwork.LOGGER.error("Error thrown from a connected block" + e);
                    }
                }
                if (matcher.getStack().m_41619_() || amtToRequest == 0 || (requestedStack = this.request((ItemStackMatcher)matcher, amtToRequest, true)).m_41619_()) continue;
                ItemStack insertedSim = storage.insertStack(requestedStack, true);
                if (!insertedSim.m_41619_()) {
                    int movedItems = requestedStack.m_41613_() - insertedSim.m_41613_();
                    if (movedItems <= 0) continue;
                    requestedStack.m_41764_(movedItems);
                }
                if ((realExtractedStack = this.request(new ItemStackMatcher(requestedStack, false, true), requestedStack.m_41613_(), false)).m_41619_()) continue;
                storage.insertStack(realExtractedStack, false);
                continue block2;
            }
        }
    }

    public ItemStack request(ItemStackMatcher matcher, int size, boolean simulate) {
        if (size == 0 || matcher == null) {
            return ItemStack.f_41583_;
        }
        ItemStackMatcher usedMatcher = matcher;
        int alreadyTransferred = 0;
        for (IConnectableLink storage : this.getSortedConnectableStorage()) {
            int req;
            ItemStack simExtract = storage.extractStack(usedMatcher, req = size - alreadyTransferred, simulate);
            if (simExtract.m_41619_()) continue;
            usedMatcher = new ItemStackMatcher(simExtract, matcher.isOre(), matcher.isNbt());
            if ((alreadyTransferred += simExtract.m_41613_()) < size) continue;
            break;
        }
        if (alreadyTransferred <= 0) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)usedMatcher.getStack(), (int)alreadyTransferred);
    }

    private Set<IConnectable> getConnectables() {
        Set<DimPos> positions = this.getConnectablePositions();
        if (positions == null) {
            return new HashSet<IConnectable>();
        }
        HashSet<IConnectable> result = new HashSet<IConnectable>();
        for (DimPos pos : positions) {
            BlockEntity tileEntity;
            if (!pos.isLoaded() || (tileEntity = pos.getTileEntity(BlockEntity.class)) == null) continue;
            IConnectable cap = (IConnectable)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null).orElse(null);
            if (cap == null) {
                StorageNetwork.LOGGER.info("Somehow stored a dimpos that is not connectable... Skipping " + pos);
                continue;
            }
            result.add(cap);
        }
        return result;
    }

    private Set<IConnectableLink> getConnectableStorage() {
        HashSet<IConnectableLink> result = new HashSet<IConnectableLink>();
        for (DimPos dimpos : this.getConnectablePositions()) {
            IConnectableLink capConnect;
            BlockEntity tileEntity;
            if (!dimpos.isLoaded() || (tileEntity = dimpos.getTileEntity(BlockEntity.class)) == null || (capConnect = (IConnectableLink)tileEntity.getCapability(StorageNetworkCapabilities.CONNECTABLE_ITEM_STORAGE_CAPABILITY, null).orElse(null)) == null) continue;
            if (tileEntity instanceof TileExchange) {
                StorageNetwork.log("keep going??main tile exhchange bandaid");
            }
            result.add(capConnect);
        }
        return result;
    }

    private List<IConnectableLink> getSortedConnectableStorage() {
        return this.getConnectableStorage().stream().sorted(Comparator.comparingInt(IConnectableLink::getPriority)).collect(Collectors.toList());
    }

    private void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.getConnectablePositions() == null || this.f_58857_.m_46467_() % (long)StorageNetwork.CONFIG.refreshTicks() == 0L || this.shouldRefresh) {
            try {
                this.connectables = this.getConnectables(this.getDimPos());
                this.shouldRefresh = false;
                this.f_58857_.m_46865_(this.f_58858_).m_8092_(true);
            }
            catch (Throwable e) {
                StorageNetwork.LOGGER.info("Refresh network error ", e);
            }
        }
        this.updateImports();
        this.updateExports();
        this.updateProcess();
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        CompoundTag syncData = new CompoundTag();
        this.m_6945_(syncData);
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, syncData);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public static boolean shouldRefresh(Level world, BlockPos pos, BlockState oldState, BlockState newSate) {
        return oldState.m_60734_() != newSate.m_60734_();
    }

    public Set<DimPos> getConnectablePositions() {
        if (this.connectables == null) {
            this.connectables = new HashSet<DimPos>();
        }
        return new HashSet<DimPos>(this.connectables);
    }

    public void clearCache() {
        this.importCache = new HashMap<String, DimPos>();
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileMain tile) {
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileMain tile) {
        tile.tick();
    }
}

