/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.ITileNetworkSync;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SortClientMessage {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;

    private SortClientMessage() {
    }

    public SortClientMessage(BlockPos pos, boolean direction, EnumSortType sort) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
    }

    public static void handle(SortClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            BlockEntity tileEntity = mc.f_91073_.m_7702_(message.pos);
            if (tileEntity instanceof ITileNetworkSync) {
                ITileNetworkSync ts = (ITileNetworkSync)tileEntity;
                ts.setDownwards(message.direction);
                ts.setSort(message.sort);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static SortClientMessage decode(FriendlyByteBuf buf) {
        SortClientMessage message = new SortClientMessage();
        message.direction = buf.readBoolean();
        int sort = buf.readInt();
        message.sort = EnumSortType.values()[sort];
        message.pos = buf.m_130135_();
        return message;
    }

    public static void encode(SortClientMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.direction);
        buf.writeInt(msg.sort.ordinal());
        if (msg.pos != null) {
            buf.m_130064_(msg.pos);
        } else {
            buf.m_130064_(BlockPos.f_121853_);
        }
    }
}

